/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - lvcolwidth.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
INT32 __stdcall LV_GetHdrWidth(HWND hWnd, INT32 nColIdx, INT32 nXWidth) {
INT32	nWidth;

	ListView_SetColumnWidth(hWnd, nColIdx, LVSCW_AUTOSIZE_USEHEADER);
	nWidth = ListView_GetColumnWidth(hWnd, nColIdx);
	return nWidth + nXWidth;
}
// **********************************************************************************
void __stdcall LV_GetHdrsWidth(HWND hWnd, INT32 nXWidth, INT32 nColCnt, LPINT32 lpMinWidth) {
LVCOLUMN		lvc;
char			c;
INT32			i;

	MemClr(&lvc, sizeof(lvc));
	lvc.mask = LVCF_FMT | LVCF_TEXT | LVCF_WIDTH | LVCF_SUBITEM;
	lvc.pszText = &c;
	c = 0;
	lvc.cx = LVSCW_AUTOSIZE;
	lvc.fmt = LVCFMT_LEFT;
	lvc.iSubItem = nColCnt;
	ListView_InsertColumn(hWnd, nColCnt, &lvc);
	for (i = 0; i < nColCnt; i++) {
		lpMinWidth[i] = LV_GetHdrWidth(hWnd, i, nXWidth);
	}
	ListView_DeleteColumn(hWnd, nColCnt);
}
// **********************************************************************************
void __stdcall LV_SetColWidth(HWND hWnd, INT32 nColIdx, INT32 nHdrWidth) {
INT32	nWidth;

	ListView_SetColumnWidth(hWnd, nColIdx, LVSCW_AUTOSIZE);
	nWidth = ListView_GetColumnWidth(hWnd, nColIdx);
	if (nWidth < nHdrWidth) ListView_SetColumnWidth(hWnd, nColIdx, nHdrWidth);
}
// **********************************************************************************
void __stdcall LV_SetColsWidth(HWND hWnd, INT32 nColCnt, LPINT32 lpMinWidth, LPINT32 lpColWidth) {
INT32			i;

	for (i = 0; i < nColCnt; i++) {
		if (i == (nColCnt - 1)) ListView_SetColumnWidth(hWnd, i, LVSCW_AUTOSIZE_USEHEADER);
		else LV_SetColWidth(hWnd, i, lpMinWidth[i]);
		lpColWidth[i] = ListView_GetColumnWidth(hWnd, i);
	}
}
// **********************************************************************************
void __stdcall LV_AddItem(BOOL bInsert, HWND hWnd, LPLVITEM lpLvi, LPINT32 lpStrWidth) {
RECT	rc;
INT32	nCol;

	if (bInsert) {
		ListView_InsertItem(hWnd, lpLvi);
	}
	else {
		ListView_SetItem(hWnd, lpLvi);
	}
	if (lpLvi->pszText[0]) {
		MeasureText(NULL, hWnd, NULL, lpLvi->pszText, &rc, FALSE);
		nCol = lpLvi->iSubItem;
		if (rc.right > lpStrWidth[nCol]) lpStrWidth[nCol] = rc.right;
	}
}
// **********************************************************************************
BOOL __stdcall LV_UpdateItem(HWND hWnd, LPLVITEM lpLvi, LPINT32 lpStrWidth, LPINT32 lpColWidth) {
RECT	rc;
INT32	nCol;
BOOL	bChg;

	bChg = FALSE;
	ListView_SetItem(hWnd, lpLvi);
	if (lpLvi->pszText[0]) {
		MeasureText(NULL, hWnd, NULL, lpLvi->pszText, &rc, FALSE);
		nCol = lpLvi->iSubItem;
		if (rc.right > lpStrWidth[nCol]) {
			lpColWidth[nCol] += rc.right - lpStrWidth[nCol];
			lpStrWidth[nCol] = rc.right;
			ListView_SetColumnWidth(hWnd,  nCol, lpColWidth[nCol]);
			bChg = TRUE;
		}
	}
	return bChg;
}
