/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - lvhdrsortimg.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
void __stdcall LV_SetHdrSortImage(HINSTANCE hInst, HWND hWnd, BOOL bComCtl6, INT32 nColIdx, INT32 nMode, INT32 nUpArrowID) {
HWND		hLVHdr;
HDITEM		hi;
INT32		nBitmap;

	hLVHdr = ListView_GetHeader(hWnd);
	MemClr(&hi, sizeof(HDITEM));
	hi.mask = HDI_FORMAT | (bComCtl6 ? 0 : HDI_BITMAP);
	Header_GetItem(hLVHdr, nColIdx, &hi);
	if (bComCtl6) {
		hi.fmt &= ~(HDF_SORTDOWN | HDF_SORTUP);
		if (nMode > 0) hi.fmt |= HDF_SORTUP;
		else if (nMode < 0) hi.fmt |= HDF_SORTDOWN;
	}
	else {
		if (hi.hbm) DeleteObject(hi.hbm);
		if (nMode) {
			hi.fmt |= HDF_BITMAP | HDF_BITMAP_ON_RIGHT;
			nBitmap = nUpArrowID;
			if (nMode < 0) nBitmap++;
			hi.hbm = (HBITMAP) LoadImage(hInst, RESSTR(nBitmap), IMAGE_BITMAP, 0, 0, LR_LOADMAP3DCOLORS);
		}
		else {
			hi.mask &= ~HDI_BITMAP;
			hi.fmt &= ~(HDF_BITMAP | HDF_BITMAP_ON_RIGHT);
		}
	}
	Header_SetItem(hLVHdr, nColIdx, &hi);
}
