/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - lvsubclass.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#pragma pack(push, 1)
#define SUBCLASSID		'SKSC'
typedef struct tagMYUSERDATA {
	INT32			nID;
	HWND			hHdr;
	CUSTOMDRAWPROC	pDraw;
	WNDPROC			ViewProc;
	WNDPROC			HdrProc;
	BOOL			bClick;
} MYUSERDATA, *LPMYUSERDATA;
#pragma pack(pop)
// **********************************************************************************
static LRESULT __stdcall WndProcListView(HWND hWnd, UINT32 nMsg, WPARAM wParam, LPARAM lParam) {
LPMYUSERDATA	pData;
LPNMHDR			pHdr;

	pData = (LPMYUSERDATA) GetWindowLong(hWnd, GWL_USERDATA);
	if (pData->nID == SUBCLASSID) {
		if (nMsg == WM_NOTIFY) {
// Catch the resize messages for the ListView Header and abort the resizing
			pHdr = (LPNMHDR) lParam;
			if ((pHdr->code == HDN_BEGINTRACKW) || (pHdr->code == HDN_BEGINTRACKA))	return TRUE;
			if ((pHdr->code == NM_CUSTOMDRAW) && (pHdr->hwndFrom == pData->hHdr)) {
				if (pData->pDraw) return pData->pDraw(pHdr);
			}
		}
// Send all other messages to the ListViews original WndProc
		return CallWindowProc(pData->ViewProc, hWnd, nMsg, wParam, lParam);
	}
	else return FALSE;
}
// **********************************************************************************
static LRESULT __stdcall WndProcListViewHeader(HWND hWnd, UINT32 nMsg, WPARAM wParam, LPARAM lParam) {
LPMYUSERDATA	pData;

	pData = (LPMYUSERDATA) GetWindowLong(hWnd, GWL_USERDATA);
	if (pData->nID == SUBCLASSID) {
		switch(nMsg) {
// Stop the header from changing to the "change column width mouse cursor"
// Without this it will look like the user can resize, but he won't be able to do it
		case WM_SETCURSOR:
			return TRUE;
// Stop the user from resizing by double clicking on the header
		case WM_LBUTTONDOWN:
		case WM_LBUTTONUP:
			if (pData->bClick) break;
		case WM_LBUTTONDBLCLK:
			return 0;
		}
// Send all other messages to the ListView Headers original WndProc
		return CallWindowProc(pData->HdrProc, hWnd, nMsg, wParam, lParam);
	}
	else return FALSE;
}
// **********************************************************************************
BOOL __stdcall LV_SubClass(HWND hWnd, BOOL bClick, CUSTOMDRAWPROC lpDrawProc) {
LPMYUSERDATA	pData;
HWND			hWndHdr;
UINT32			nLV, nHdr;

	if (!IsWindow(hWnd)) return FALSE;
	hWndHdr = ListView_GetHeader(hWnd);
	if (!hWndHdr) return FALSE;
	pData = GetMem(GMM_CLEAR, sizeof(MYUSERDATA));
	if (!pData) return FALSE;
	nLV = SetWindowLong(hWnd, GWL_USERDATA, (LONG) pData);
	nHdr = SetWindowLong(hWndHdr, GWL_USERDATA, (LONG) pData);
	if (nLV || nHdr) {
		SetWindowLong(hWnd, GWL_USERDATA, (LONG) nLV);
		SetWindowLong(hWndHdr, GWL_USERDATA, (LONG) nHdr);
		FreeMem(pData);
		return FALSE;
	}
	pData->hHdr = hWndHdr;
	pData->pDraw = lpDrawProc;
	pData->bClick = bClick;
// First subclass the ListView
	pData->ViewProc = (WNDPROC) SetWindowLong(hWnd, GWLP_WNDPROC, (LONG) WndProcListView);
// Then subclass the ListView Header (you can send LVM_GETHEADER message with SendMessage instad of ListView_GetHeader if you want to)
	pData->HdrProc = (WNDPROC) SetWindowLong(hWndHdr, GWLP_WNDPROC, (LONG) WndProcListViewHeader);
	pData->nID = SUBCLASSID;
	return TRUE;
}
// **********************************************************************************
BOOL __stdcall LV_UnSubClass(HWND hWnd) {
LPMYUSERDATA	pData;

	if (!IsWindow(hWnd)) return FALSE;
	pData = (LPMYUSERDATA) GetWindowLong(hWnd, GWL_USERDATA);
	if (!pData || (pData->nID != SUBCLASSID)) return FALSE;
	SetWindowLong(hWnd, GWLP_WNDPROC, (LONG) pData->ViewProc);
	SetWindowLong(pData->hHdr, GWLP_WNDPROC, (LONG) pData->HdrProc);
	SetWindowLong(hWnd, GWL_USERDATA, (LONG) 0);
	SetWindowLong(pData->hHdr, GWL_USERDATA, (LONG) 0);
	FreeMem(pData);
	return TRUE;
}
