/********************************************************************
 * Copyright (c) 2011-17 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - loadbinfile.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "private.h"
// **********************************************************************************
INT32 __stdcall LoadBinFile(LPSTR lpFileName, INT32 nMinSize, INT32 nMaxSize, BOOL bAlloc, LPVOID *lpBuf, LPINT32 lpError) {
LPFILEIO	pFile;
LPSTR		pBuf;
INT64		nBigSize;
INT32		nSize, nErr;

	nBigSize = GetFSize(lpFileName, &nErr);
	if (nErr) nSize = 0;
	else {
		nSize = (INT32) nBigSize;
		if (lpBuf && nSize && (nBigSize <= MAX_SIGNED32) && (nSize >= nMinSize) && (bAlloc || (nSize <= nMaxSize))) {
			pBuf = bAlloc ? GetMem(GMM_DEFAULT, nSize) : *lpBuf;
			pFile = FOpen(lpFileName, FOM_READ | FOM_SHARE, NULL);
			if (pFile && pBuf) {
				if (!pFile->nErr) {
					nSize = FRead(pFile, pBuf, nSize);
				}
				nErr = FClose(pFile);
			}
			else nErr = ERROR_OUTOFMEMORY;
			if (nErr && bAlloc) FreeMem(pBuf);
		}
		else nErr = ERROR_INVALID_DATA;
	}
	if (nErr) {
		pBuf = NULL;
		nSize = 0;
	}
	if (bAlloc) *lpBuf = pBuf;
	if (lpError) *lpError = nErr;
	return nSize;
}
