/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - loadtextfile.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "private.h"
// **********************************************************************************
LPSTR __stdcall LoadTextFile(LPSTR lpFileName, INT32 nFlags, INT32 nMaxLen, LPINT32 lpRdLen) {
LPFILEIO	pFile;
LPSTR		pBuf, pSrch;
INT32		nRdLen, nSize;
BOOL		bScan, bOK;

	if (nMaxLen > ABSMAX_TEXTFILESIZE) nMaxLen = ABSMAX_TEXTFILESIZE;
	pBuf = NULL;
	nSize = nRdLen = bScan = 0;
	pFile = FOpen(lpFileName, FOM_READ | FOM_SHARE, NULL);
	if (pFile) {
		if (pFile->nSize < nMaxLen) nSize = pFile->nSizeLo;
		else {
			nSize = nMaxLen;
			if (nFlags & LTF_FROMEND) {
				FSeek(pFile, pFile->nSize - nMaxLen, FSM_BEGIN);
				bScan = TRUE;
			}
		}
		if (nSize && !pFile->nErr) {
			pBuf = GetMem(GMM_DEFAULT, nSize + TXT_EXTRABUFSIZE);
			if (pBuf) {
				nRdLen = FRead(pFile, pBuf, nSize);
				if (pFile->nErr) {
					FreeMem(pBuf);
					nRdLen = 0;
				}
			}
		}
		FClose(pFile);
	}
	if (nRdLen) {
		if (bScan) {
			pSrch = pBuf;
			while (nRdLen--) {
				if (*pSrch++ == '\n') {
					if (bOK = (nFlags & LTF_SKIPHT) ? *pSrch != '\t' : TRUE) {
						if ((nFlags & LTF_SKIPSPC) && (*pSrch == ' ')) bOK = FALSE;
					}
					if (bOK) {
						MemCpy(pBuf, pSrch, nRdLen);
						break;
					}
				}
			}
		}
		if (nFlags & LTF_ADDCRLF) {
			if ((nRdLen < 2) || (pBuf[nRdLen - 2] != '\r') || (pBuf[nRdLen - 1] != '\n')) {
				if (pBuf[nRdLen - 1] != '\r') pBuf[nRdLen++] = '\r';
				pBuf[nRdLen++] = '\n';
			}
		}
	}
	nSize = nRdLen + ((nFlags & LTF_EXTRABUF) ? TXT_EXTRABUFSIZE : 0);
	if (nSize) nSize++;
	pBuf = ModifyMem(pBuf, GMM_DEFAULT, nSize);
	if (pBuf) pBuf[nRdLen] = 0;
	if (lpRdLen) *lpRdLen = nRdLen;
	return pBuf;
}
