/********************************************************************
 * Copyright (c) 2011-21 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - messageloop											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
INT32 __stdcall MessageLoop(LPBOOL lpErr) {
LPTIDDATA	pTid;
MSG			Msg;
INT32		nRes;

	if (lpErr) *lpErr = FALSE;
	pTid = _getptd();
	pTid->bThreadActive = TRUE;
	while (pTid->bThreadActive && (nRes = GetMessage(&Msg, NULL, 0, 0))) {
		if (nRes == -1) {
			if (lpErr) {
				*lpErr = TRUE;
				break;
			}
		}
		else {
			if (!pTid->hDlg || !IsDialogMessage(pTid->hDlg, &Msg)) {
				if (!pTid->hWnd || !pTid->hAccel || !TranslateAccelerator(pTid->hWnd, pTid->hAccel, &Msg)) {
					TranslateMessage(&Msg);
					DispatchMessage(&Msg);
				}
			}
		}
	}
	nRes = (nRes == 0) && pTid->bThreadActive ? Msg.wParam : -1;
	return nRes;
}
