/********************************************************************
 * Copyright (c) 2011-17 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - msgboxtout.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>

#pragma pack(push)
typedef struct tagMSGINFO {
	HANDLE volatile			hThread;
	HWND					hOwner;
	INT32					nMode;
	INT32					nRet;
	char					cStrs[3];
} MSGINFO, *LPMSGINFO;

#pragma pack(pop)

// **********************************************************************************
static UINT32 __stdcall MsgThreadProc(LPMSGINFO lpInfo) {
LPSTR		pTitle, pMsg1, pMsg2;

	__try {
		pTitle = &lpInfo->cStrs[0];
		pMsg1 = pTitle + 1 + StrLen(pTitle);
		pMsg2 = pMsg1 + 1 + StrLen(pMsg1);
		lpInfo->nRet = MsgBox(lpInfo->hOwner, pTitle, pMsg1, pMsg2, lpInfo->nMode);
	}
	__except(EXCEPTION_EXECUTE_HANDLER) {
		lpInfo->nRet = -1;
	} // end of try - except
	lpInfo->hThread = NULL;
	return 0;
}	// end of MsgThreadProc()
// **********************************************************************************
INT32 __stdcall MsgBoxWithTimeOut(HWND hWndOwner, LPSTR lpTitle, LPSTR lpMsg1, LPSTR lpMsg2, INT32 nMode, UINT32 nMilliSec) {
INT32		nSize, nRet;
UINT32		nStart, nDelta;
LPSTR		pStr;
LPMSGINFO	pInfo;

	nSize = sizeof(MSGINFO) + StrLen(lpTitle) + StrLen(lpMsg1) + StrLen(lpMsg2);
	pInfo = GetMem(GMM_CLEAR, nSize);
	pStr = &pInfo->cStrs[0];
	pStr += 1 + StrCpy(pStr, lpTitle);
	pStr += 1 + StrCpy(pStr, lpMsg1);
	StrCpy(pStr, lpMsg2);
	pInfo->hOwner = hWndOwner;
	pInfo->nMode = nMode;
	if (!(pInfo->hThread = SimpleThread(MsgThreadProc, pInfo))) nRet = -1;
	nStart = GetTickCount();
	do {
		nDelta = GetTickCount() - nStart;
		nRet = pInfo->nRet;
		if (!nRet) {
			if (nDelta >= nMilliSec) {
				nRet = -1;
				TerminateThread(pInfo->hThread, -1);
			}
			else Sleep(0);
		}
	} while (!nRet);
	FreeMem(pInfo);
	return nRet;
}
