/********************************************************************
 * Copyright (c) 2011-19 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - ntp_gettime.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"
#include <ws2ipdef.h>

#pragma comment(lib, "ws2_32.lib")

#pragma pack(push, 1)

typedef struct tagNTPTIME {
	UINT32	nLow;
	UINT32	nHigh;
} NTPTIME, *LPNTPTIME;

typedef struct tagNTPPACKET {
	UINT8		li_vn_mode;			// leap indicator, version and mode
	UINT8		stratum;			// peer stratum
	UINT8		ppoll;				// peer poll interval
	INT8		precision;			// peer clock precision
	UINT32		rootdelay;			// distance to primary clock
	UINT32		rootdispersion;		// clock dispersion
	UINT32		refid;				// reference clock ID
	NTPTIME		ref;				// time peer clock was last updated
	NTPTIME		org;				// originate time stamp
	NTPTIME		rec;				// receive time stamp
	NTPTIME		xmt;				// transmit time stamp
} NTPPACKET, *LPNTPPACKET;

// **********************************************************************************
BOOL __stdcall NTP_GetTime(UINT32 nSkt, UINT32 nIP, INT32 nPort, INT32 nZone, BOOL bDayLight, LPSYSTEMTIME lpSt) {
SOCKETADDRESS		saSrvr;
INT32				nResult, nLen, nDelta;
BOOL				bRet;
NTPPACKET			Pkt;

	bRet = FALSE;
	if (lpSt) {
		MemClr(&saSrvr, sizeof(SOCKETADDRESS));
		MemClr(lpSt, sizeof(SYSTEMTIME));
		saSrvr.nFamily = AF_INET;
		saSrvr.nPort = ByteSwap16(nPort);
		saSrvr.nIp = nIP;
		MemClr(&Pkt, sizeof(Pkt));
		Pkt.li_vn_mode = 11;
		Pkt.ppoll = 4;
		nResult = sendto(nSkt, (LPSTR) &Pkt, sizeof(Pkt), 0, &saSrvr.sa, sizeof(SOCKETADDRESS));
		if (nResult == sizeof(Pkt)) {
			nLen = sizeof(SOCKETADDRESS);
			nResult = recvfrom(nSkt, (LPSTR) &Pkt, sizeof(Pkt), 0, &saSrvr.sa, &nLen);
			if ((nResult == sizeof(Pkt)) && ((Pkt.li_vn_mode & 0x3F) == 12)) {
				bRet = TRUE;
				Pkt.xmt.nLow = ByteSwap32(Pkt.xmt.nLow);
				Pkt.xmt.nHigh = ByteSwap32(Pkt.xmt.nHigh);
				nDelta = nZone * 3600;
				if (bDayLight) nDelta += 3600;
				Pkt.xmt.nLow += nDelta;
				DayToDate(Pkt.xmt.nLow / SECONDSOFDAY, 1900, lpSt);
				SecToTime(Pkt.xmt.nLow % SECONDSOFDAY, lpSt);
				lpSt->wMilliseconds = 1000 * (Pkt.xmt.nHigh >> 16) / 65536;
			}
		}
	}
	return bRet;
}
