/********************************************************************
 * Copyright (c) 2019 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - opc_callback.cpp										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#define _SYS_GUID_OPERATORS_
#include "OpcError.h"
#include "opcda.h"
#include <skclib32.h>
#include <sklibopc.h>

// **********************************************************************************
COPCCallBack::COPCCallBack() {

    m_nRef = 0;
    m_pGrp = NULL;
}
// **********************************************************************************
COPCCallBack::~COPCCallBack() {

	if (m_pGrp) m_pGrp->bConnected = 0;
}
// **********************************************************************************
// IUnknown methods
HRESULT __stdcall COPCCallBack::QueryInterface(REFIID riid, LPVOID *ppv) {
HRESULT	hRes;

	if (ppv == NULL) return E_POINTER;
	*ppv = NULL;
	if ((MemCmp((LPVOID) &riid, (LPVOID) &IID_IUnknown, sizeof(GUID)) == 0) ||
		(MemCmp((LPVOID) &riid, (LPVOID) &IID_IOPCDataCallback, sizeof(GUID)) == 0)) {
		*ppv = (IUnknown*) this;
		hRes = S_OK;
		AddRef();
	}
	else hRes = E_NOINTERFACE;
	return hRes;
}
// **********************************************************************************
ULONG __stdcall COPCCallBack::AddRef(void) {

	return InterlockedIncrement( &m_nRef);
}
// **********************************************************************************
ULONG __stdcall COPCCallBack::Release(void) {
ULONG	nRet;

	if (InterlockedDecrement(&m_nRef) == 0) {
		delete this;
		nRet = 0;
	}
	else nRet = m_nRef;
	return nRet;
}
// **********************************************************************************
HRESULT __stdcall COPCCallBack::OnDataChange(DWORD dwTransid, OPCHANDLE hGroup, HRESULT hrMasterquality, HRESULT hrMastererror,
												DWORD dwCount, LPOPCHANDLE phClientItems, LPVARIANT pvValues, LPWORD pwQualities,
												LPFILETIME pftTimeStamps, LPHRESULT pErrors) {
UINT32		i;

	if (!m_pGrp || !dwCount) return S_OK;
	for (i = 0; i < dwCount; i++) {
		SetReadData((LPOPCITEM) phClientItems[i], pErrors[i], pwQualities[i], &pftTimeStamps[i], &pvValues[i]);
	}
	return S_OK;
};
// **********************************************************************************
// OnReadComplete is being called by OPC server when an async read request has been carried out
HRESULT __stdcall COPCCallBack::OnReadComplete(DWORD dwTransid, OPCHANDLE hGroup, HRESULT hrMasterquality, HRESULT hrMastererror,
												DWORD dwCount, LPOPCHANDLE phClientItems, LPVARIANT pvValues, LPWORD pwQualities,
												LPFILETIME pftTimeStamps, LPHRESULT pErrors) {

	return OnDataChange(dwTransid, hGroup, hrMasterquality, hrMastererror, dwCount, phClientItems, pvValues, pwQualities, pftTimeStamps, pErrors);
};
// **********************************************************************************
// OnWriteComplete called by OPC server when an async write request has been carried out
HRESULT __stdcall COPCCallBack::OnWriteComplete(DWORD dwTransid, OPCHANDLE hGroup, HRESULT hrMastererr, DWORD dwCount, LPOPCHANDLE pClienthandles, LPHRESULT pErrors) {
UINT32		i;

	if (!m_pGrp || !dwCount) return S_OK;
	for (i = 0; i < dwCount; i++) {
		ClearWriteRequest((LPOPCITEM) pClienthandles[i], pErrors[i]);
	}
	return S_OK;
};
// **********************************************************************************
HRESULT __stdcall COPCCallBack::OnCancelComplete(DWORD dwTransid, OPCHANDLE hGroup) {

	return S_OK;
};
// **********************************************************************************
void __stdcall COPCCallBack::Connect(LPOPCGROUP lpGrp) {

	if (lpGrp && !m_pGrp) {
		m_pGrp = lpGrp;
		lpGrp->bConnected = 1;
	}
}
// **********************************************************************************
void __stdcall COPCCallBack::SetReadData(LPOPCITEM lpItem, HRESULT hRes, WORD nQuality, LPFILETIME lpFt, LPVARIANT lpVar) {
BOOL		bOK, bBool, bInt, bUInt, bGood, bUncertain;
INT32		nQual;
OPCVALUE	Value;

	bOK = bBool = bInt = bUInt = FALSE;
	nQual = nQuality & OPC_QUALITY_MASK;
	bGood = nQual == OPC_QUALITY_GOOD;
	bUncertain = nQual == OPC_QUALITY_UNCERTAIN;
	if ((hRes == S_OK) && (bGood || bUncertain)) {
		switch (lpVar->vt) {
		case VT_BOOL:
			Value.i32 = lpVar->boolVal;
			bBool = TRUE;
			break;
		case VT_I1:
			Value.i32 = lpVar->cVal;
			bInt = TRUE;
			break;
		case VT_I2:
			Value.i32 = lpVar->iVal;
			bInt = TRUE;
			break;
		case VT_I4:
		case VT_INT:
			Value.i32 = lpVar->intVal;
			bInt = TRUE;
			break;
		case VT_UI1:
			Value.u32 = lpVar->bVal;
			bUInt = TRUE;
			break;
		case VT_UI2:
			Value.u32 = lpVar->uiVal;
			bUInt = TRUE;
			break;
		case VT_UI4:
		case VT_UINT:
			Value.u32 = lpVar->uintVal;
			bUInt = TRUE;
			break;
		}
		switch (lpItem->vtClntType) {
		case VTC_BOOL:
			if (bBool || bInt || bUInt) {
				lpItem->Value.b = (Value.i32) ? 1 : 0;
				bOK = TRUE;
			}
			break;
		case VTC_INT32:
			if (bInt || bUInt) {
				lpItem->Value.i32 = Value.i32;
				bOK = TRUE;
			}
			break;
		case VTC_UINT32:
			if (bInt || bUInt) {
				lpItem->Value.u32 = Value.u32;
				bOK = TRUE;
			}
			break;
		case VTC_INT64:
		case VTC_UINT64:
			if ((lpVar->vt == VT_I8) || (lpVar->vt == VT_I8)) {
				lpItem->Value.i64 = lpVar->llVal;
				bOK = TRUE;
			}
			break;
		case VTC_DOUBLE:
			switch (lpVar->vt) {
			case VT_R4:
				lpItem->Value.d = lpVar->fltVal;
				bOK = TRUE;
				break;
			case VT_DATE:
			case VT_R8:
				lpItem->Value.d = lpVar->dblVal;
				bOK = TRUE;
				break;
			}
			break;
		case VTC_STR:
			switch (lpVar->vt) {
			case VT_BSTR:
			case VT_LPWSTR:
				WideCharToAnsi(lpItem->Value.pStr, lpItem->nMaxStrLen, lpVar->bstrVal, lpItem->nMaxStrLen << 1, WCTA_LE, NULL);
				bOK = TRUE;
				break;
			case VT_LPSTR:
				StrCpyN(lpItem->Value.pStr, lpVar->pcVal, lpItem->nMaxStrLen);
				bOK = TRUE;
				break;
			}
			break;
		case VTC_WSTR:
			switch (lpVar->vt) {
			case VT_BSTR:
			case VT_LPWSTR:
				WStrCpyN(lpItem->Value.pWStr, lpVar->bstrVal, lpItem->nMaxStrLen);
				bOK = TRUE;
				break;
			case VT_LPSTR:
				AnsiToWideChar(lpItem->Value.pWStr, lpVar->pcVal, lpItem->nMaxStrLen, WCTA_LE);
				bOK = TRUE;
				break;
			}
			break;
		}
	}
	if (bOK) {
		lpItem->ftStamp.dwLowDateTime = lpFt->dwLowDateTime;
		lpItem->ftStamp.dwHighDateTime = lpFt->dwHighDateTime;
		lpItem->bReadError = 0;
		lpItem->bUncertain = (bUncertain) ? 1 : 0;
	}
	else {
		lpItem->bReadError = 1;
	}
	lpItem->bIsUpdated = 1;
}
// **********************************************************************************
void __stdcall COPCCallBack::ClearWriteRequest(LPOPCITEM lpItem, HRESULT hRes) {

	lpItem->bWrRequest = 0;
	lpItem->bIsUpdated = 1;
	lpItem->bWriteError = (hRes == S_OK) ? 0 : 1;
}
