/********************************************************************
 * Copyright (c) 2019 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - opc_main.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#define _SYS_GUID_OPERATORS_
#include <skclib32.h>
#include <sklibopc.h>

// **********************************************************************************
LPOPCSERVER __stdcall OPC_Init(LPSTR lpHostName, LPSTR lpServerName) {
LPOPCSERVER		pSrvr;
INT32			nHostLen, nSrvrLen;

	nHostLen = StrLen(lpHostName);
	nSrvrLen = StrLen(lpServerName);
	pSrvr = GetMem(GMM_CLEAR, sizeof(OPCSERVER) + nHostLen + nSrvrLen);
	if (pSrvr) {
		pSrvr->pHost = &pSrvr->cNames[0];
		pSrvr->pServer = &pSrvr->cNames[nHostLen + 1];
		MemCpy(pSrvr->pHost, lpHostName, nHostLen);
		MemCpy(pSrvr->pServer, lpServerName, nSrvrLen);
	}
	return pSrvr;
}
// **********************************************************************************
INT32 __stdcall OPC_Done(LPOPCSERVER lpSrvr) {

	if (!lpSrvr) return OPCERR_SERVERNONE;
	if (lpSrvr->bActive) return OPCERR_SERVERSTARTED;
	while (lpSrvr->pGroups) {
		OPC_DelGroup(lpSrvr, lpSrvr->pGroups->hClient);
	}
	FreeMem(lpSrvr);
	return OPCERR_NONE;
}
// **********************************************************************************
INT32 __stdcall OPC_AddGroup(LPOPCSERVER lpSrvr, LPSTR lpGroupName, UINT32 nGrpID, UINT32 nRefreshRate, BOOL bSyncIO) {
LPOPCGROUP		pGrp;
INT32			nLen;

	if (!lpSrvr) return OPCERR_SERVERNONE;
	if (lpSrvr->bActive) return OPCERR_SERVERSTARTED;
	pGrp = Chain_GetItem(nGrpID, lpSrvr->pGroups);
	if (pGrp) return OPCERR_GROUPEXISTS;
	nLen = StrLen(lpGroupName);
	pGrp = GetMem(GMM_CLEAR, sizeof(OPCGROUP) + nLen);
	if (!pGrp) return OPCERR_NOMEMORY;
	MemCpy(pGrp->cName, lpGroupName, nLen);
	pGrp->hClient = nGrpID;
	pGrp->nUpdateRate = nRefreshRate;
	pGrp->bSyncRead = (bSyncIO) ? 1 : 0;
	lpSrvr->pGroups = Chain_AddItem(pGrp, lpSrvr->pGroups);
	lpSrvr->nGrpCnt++;
	return OPCERR_NONE;
}
// **********************************************************************************
INT32 __stdcall OPC_DelGroup(LPOPCSERVER lpSrvr, UINT32 nGrpID) {
LPOPCGROUP		pGrp;

	if (!lpSrvr) return OPCERR_SERVERNONE;
	if (lpSrvr->bActive) return OPCERR_SERVERSTARTED;
	pGrp = Chain_GetItem(nGrpID, lpSrvr->pGroups);
	if (!pGrp) return OPCERR_GROUPNOTEXISTS;
	while (pGrp->pItems) {
		OPC_DelItem(lpSrvr, nGrpID, pGrp->pItems->hClient);
	}
	lpSrvr->pGroups = Chain_DelItem(pGrp->hClient, lpSrvr->pGroups);
	lpSrvr->nGrpCnt--;
	FreeMem(pGrp);
	return OPCERR_NONE;
}
// **********************************************************************************
LPOPCGROUP __stdcall OPC_GetGroup(LPOPCSERVER lpSrvr, UINT32 nGrpID) {
LPOPCGROUP		pGrp;

	if (!lpSrvr) return NULL;
	pGrp = Chain_GetItem(nGrpID, lpSrvr->pGroups);
	return pGrp;
}
// **********************************************************************************
INT32 __stdcall OPC_AddItem(LPOPCSERVER lpSrvr, UINT32 nGrpID, LPSTR lpItemName, UINT32 nItemID, INT32 nVarType, INT32 nMaxLen) {
LPOPCGROUP		pGrp;
LPOPCITEM		pItem;
INT32			nLen;

	if (!lpSrvr) return OPCERR_SERVERNONE;
	if (lpSrvr->bActive) return OPCERR_SERVERSTARTED;
	pGrp = Chain_GetItem(nGrpID, lpSrvr->pGroups);
	if (!pGrp) return OPCERR_GROUPNOTEXISTS;
	pItem = Chain_GetItem(nItemID, pGrp->pItems);
	if (pItem) return OPCERR_ITEMEXISTS;
	if ((nVarType < VTC_MIN) || (nVarType > VTC_MAX)) return OPCERR_UNSUPPORTEDTYPE;
	nLen = StrLen(lpItemName);
	pItem = GetMem(GMM_CLEAR, sizeof(OPCITEM) + nLen);
	if (!pItem) return OPCERR_NOMEMORY;
	MemCpy(pItem->cName, lpItemName, nLen);
	pItem->hClient = nItemID;
	pItem->vtClntType = nVarType;
	pGrp->pItems = Chain_AddItem(pItem, pGrp->pItems);
	if ((nVarType == VTC_STR) || (nVarType == VTC_WSTR)) {
		if (nMaxLen < 15) nMaxLen = 15;
		if (nMaxLen > 255) nMaxLen = 255;
		pItem->nMaxStrLen = nMaxLen++;
		if (nVarType == VTC_WSTR) nMaxLen <<= 1;
		pItem->Value.pStr =  GetMem(GMM_CLEAR, nMaxLen);
		pItem->bAllocated = 1;
	}
	pGrp->nItemCnt++;
	lpSrvr->nItemCnt++;
	return OPCERR_NONE;
}
// **********************************************************************************
INT32 __stdcall OPC_DelItem(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID) {
LPOPCGROUP		pGrp;
LPOPCITEM		pItem;

	if (!lpSrvr) return OPCERR_SERVERNONE;
	if (lpSrvr->bActive) return OPCERR_SERVERSTARTED;
	pGrp = Chain_GetItem(nGrpID, lpSrvr->pGroups);
	if (!pGrp) return OPCERR_GROUPNOTEXISTS;
	pItem = Chain_GetItem(nItemID, pGrp->pItems);
	if (!pItem) return OPCERR_ITEMNOTEXISTS;
	pGrp->pItems = Chain_DelItem(pItem->hClient, pGrp->pItems);
	if (pItem->bAllocated) FreeMem(pItem->Value.pStr);
	FreeMem(pItem);
	pGrp->nItemCnt--;
	lpSrvr->nItemCnt--;
	return OPCERR_NONE;
}
// **********************************************************************************
LPOPCITEM __stdcall OPC_GetItem(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID) {
LPOPCGROUP		pGrp;
LPOPCITEM		pItem;

	if (!lpSrvr) return NULL;
	pGrp = Chain_GetItem(nGrpID, lpSrvr->pGroups);
	if (!pGrp) return NULL;
	pItem = Chain_GetItem(nItemID, pGrp->pItems);
	return pItem;
}
BOOL __stdcall OPC_ItemIsUpdated(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	return (pItem) ? pItem->bIsUpdated : FALSE;
}
// **********************************************************************************
BOOL __stdcall OPC_ReadBool(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem) {
		pItem->bIsUpdated = 0;
		return pItem->Value.b;
	}
	else return FALSE;
}
// **********************************************************************************
INT32 __stdcall OPC_ReadI32(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem) {
		pItem->bIsUpdated = 0;
		return pItem->Value.i32;
	}
	else return 0;
}
// **********************************************************************************
UINT32 __stdcall OPC_ReadU32(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem) {
		pItem->bIsUpdated = 0;
		return pItem->Value.u32;
	}
	else return 0;
}
// **********************************************************************************
INT64 __stdcall OPC_ReadI64(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID) {
LPOPCITEM		pItem;
INT64			nRet;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem) {
		pItem->bIsUpdated = 0;
		nRet = (pItem->vtClntType == VTC_INT64) ? pItem->Value.i64 : pItem->Value.i32;
		return nRet;
	}
	else return 0;
}
// **********************************************************************************
UINT64 __stdcall OPC_ReadU64(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID) {
LPOPCITEM		pItem;
UINT64			nRet;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem) {
		pItem->bIsUpdated = 0;
		nRet = (pItem->vtClntType == VTC_UINT64) ? pItem->Value.u64 : pItem->Value.u32;
		return nRet;
	}
	else return 0;
}
// **********************************************************************************
DOUBLE __stdcall OPC_ReadDbl(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID) {
LPOPCITEM		pItem;
DOUBLE			fRet;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem) {
		pItem->bIsUpdated = 0;
		fRet = pItem->Value.d;
		return fRet;
	}
	else return 0.0;
}
// **********************************************************************************
LPSTR __stdcall OPC_ReadStr(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem) {
		pItem->bIsUpdated = 0;
		return pItem->Value.pStr;
	}
	else return NULL;
}
// **********************************************************************************
LPWSTR __stdcall OPC_ReadWStr(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem) {
		pItem->bIsUpdated = 0;
		return pItem->Value.pWStr;
	}
	else return NULL;
}
// **********************************************************************************
void __stdcall OPC_WriteBool(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, BOOL bVal) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem && (pItem->vtClntType == VTC_BOOL)) {
		if (pItem->Value.b != bVal) {
			pItem->Value.b = bVal;
			pItem->bWrRequest = 1;
		}
	}
}
// **********************************************************************************
void __stdcall OPC_WriteI32(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, INT32 nVal) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem && ((pItem->vtClntType == VTC_INT32) || (pItem->vtClntType == VTC_UINT32))) {
		if (pItem->Value.i32 != nVal) {
			pItem->Value.i32 = nVal;
			pItem->bWrRequest = 1;
		}
	}
}
// **********************************************************************************
void __stdcall OPC_WriteU32(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, UINT32 nVal) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem && ((pItem->vtClntType == VTC_INT32) || (pItem->vtClntType == VTC_UINT32))) {
		if (pItem->Value.u32 != nVal) {
			pItem->Value.u32 = nVal;
			pItem->bWrRequest = 1;
		}
	}
}
// **********************************************************************************
void __stdcall OPC_WriteI64(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, INT64 nVal) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem && ((pItem->vtClntType == VTC_INT64) || (pItem->vtClntType == VTC_UINT64))) {
		if (pItem->Value.i64 != nVal) {
			pItem->Value.i64 = nVal;
			pItem->bWrRequest = 1;
		}
	}
}
// **********************************************************************************
void __stdcall OPC_WriteU64(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, UINT64 nVal) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem && ((pItem->vtClntType == VTC_INT64) || (pItem->vtClntType == VTC_UINT64))) {
		if (pItem->Value.u64 != nVal) {
			pItem->Value.u64 = nVal;
			pItem->bWrRequest = 1;
		}
	}
}
// **********************************************************************************
void __stdcall OPC_WriteDbl(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, DOUBLE fVal) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem && (pItem->vtClntType == VTC_DOUBLE)) {
		if (pItem->Value.d != fVal) {
			pItem->Value.d = fVal;
			pItem->bWrRequest = 1;
		}
	}
}
// **********************************************************************************
void __stdcall OPC_WriteStr(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, LPSTR lpStr) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem && (pItem->vtClntType == VTC_STR)) {
		if (StrCmp(pItem->Value.pStr, lpStr)) {
			StrCpyN(pItem->Value.pStr, lpStr, pItem->nMaxStrLen);
			pItem->bWrRequest = 1;
		}
	}
}
// **********************************************************************************
void __stdcall OPC_WriteWStr(LPOPCSERVER lpSrvr, UINT32 nGrpID, UINT32 nItemID, LPWSTR lpWStr) {
LPOPCITEM		pItem;

	pItem = OPC_GetItem(lpSrvr, nGrpID, nItemID);
	if (pItem && (pItem->vtClntType == VTC_WSTR)) {
		if (WStrCmp(pItem->Value.pWStr, lpWStr)) {
			WStrCpyN(pItem->Value.pWStr, lpWStr, pItem->nMaxStrLen);
			pItem->bWrRequest = 1;
		}
	}
}
