/********************************************************************
 * Copyright (c) 2019 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - opc_callback.cpp										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#define _SYS_GUID_OPERATORS_
#include "OpcError.h"
#include "opcda.h"
#include <skclib32.h>
#include <sklibopc.h>

static UINT32	m_nTransID		= 0;
static DWORD	m_nCancelID		= 0;
// **********************************************************************************
INT32 __stdcall OPC_Read(LPOPCSERVER lpSrvr, UINT32 nGrpID) {
LPOPCGROUP		pGrp;
LPOPCITEM		pItem, *phClients;
LPOPCHANDLE		phServers;
HRESULT			hRes;
INT32			i, nItems, nRet;
LPOPCITEMSTATE	pItemValue;
LPHRESULT		pErrors;
	
	if (!lpSrvr) return OPCERR_SERVERNONE;
	if (!lpSrvr->bActive) return OPCERR_SERVERSTOPPED;
	pGrp = OPC_GetGroup(lpSrvr, nGrpID);
	if (!pGrp) return OPCERR_GROUPNOTEXISTS;
	if (!pGrp->nItemCnt) return OPCERR_EMPTYGROUP;
	phServers = (LPOPCHANDLE) GetMem(GMM_CLEAR, pGrp->nItemCnt * (sizeof(OPCHANDLE) + sizeof(LPOPCITEM)));
	phClients = (LPOPCITEM *) &phServers[pGrp->nItemCnt];
	nItems = 0;
	pItem = pGrp->pItems;
	while (pItem) {
		if (!pItem->bWrRequest) {
			phServers[nItems] = pItem->hServer;
			phClients[nItems] = pItem;
			pItem = pItem->pNext;
			nItems++;
		}
	}
	nRet = OPCERR_NONE;
	if (nItems) {
		pErrors = NULL;
		if (pGrp->bSyncRead) {
			pItemValue = NULL;
			hRes = pGrp->pIOPCSyncIO->Read(OPC_DS_DEVICE, nItems, phServers, &pItemValue, &pErrors);
			if (hRes == S_OK) {
				for (i = 0; i < nItems; i++) {
					pGrp->pCallBack->SetReadData(phClients[i], hRes, pItemValue[i].wQuality, &pItemValue[i].ftTimeStamp, &pItemValue[i].vDataValue);
					VariantClear(&pItemValue[i].vDataValue);
				}
			}

			CoTaskMemFree(pItemValue);
		}
		else {
			m_nTransID++;
			hRes = pGrp->pIOPCAsyncIO2->Read(nItems, phServers, m_nTransID, &m_nCancelID, &pErrors);
		}
		if (hRes != S_OK) {
			for (i = 0; i < nItems; i++) {
				pGrp->pCallBack->SetReadData(phClients[i], hRes, 0, NULL, NULL);
			}
			nRet = OPCERR_READFAILED;
		}
		CoTaskMemFree(pErrors);
	}
	FreeMem((LPVOID) phServers);
	return nRet;
}
