/********************************************************************
 * Copyright (c) 2019 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - opc_start.cpp											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#define _SYS_GUID_OPERATORS_
#include "OpcError.h"
#include "opcda.h"
#include "opc_iid.h"
#include "opccomn.h"
#include <skclib32.h>
#include <sklibopc.h>

#define LOCALE_ID    0x409	// Code 0x409 = ENGLISH
// **********************************************************************************
static INT32 __stdcall pAddItems(LPOPCGROUP lpGrp) {
HRESULT				hRes;
INT32				nLen, nRet, nTotal, i, k;
LPWSTR				pName;
LPOPCITEM			pItem;
LPOPCITEMDEF		pItemDef;
LPOPCITEMRESULT		pItemResult;
LPHRESULT			pErrors;
BOOL				bOK;

	if (!(nTotal = lpGrp->nItemCnt)) return OPCERR_NOITEMDEFINED;
	i = 0;
	pItem = lpGrp->pItems;
	while (pItem) {
		nTotal += StrLen(pItem->cName);
		i++;
		pItem = pItem->pNext;
	}
	if (i != lpGrp->nItemCnt) return OPCERR_INTERNAL;
	pName = (LPWSTR) GetMem(GMM_CLEAR, nTotal << 1);
	pItemDef = (LPOPCITEMDEF) GetMem(GMM_CLEAR, lpGrp->nItemCnt * sizeof(OPCITEMDEF));
	i = k = 0;
	pItem = lpGrp->pItems;
	while (pItem) {
		nLen = StrLen(pItem->cName);
		AnsiToWideChar(&pName[k], pItem->cName, nLen, WCTA_LE);
		pItemDef[i].szItemID = &pName[k];
		pItemDef[i].bActive = TRUE;
		pItemDef[i].hClient = (OPCHANDLE) pItem;
		pItemDef[i].vtRequestedDataType = 0;
		k += nLen + 1;
		pItem = pItem->pNext;
		i++;
	}
	pErrors = NULL;
	pItemResult = NULL;
	hRes = lpGrp->pIOPCItemMgt->AddItems(lpGrp->nItemCnt, pItemDef, &pItemResult, &pErrors);
	if (SUCCEEDED(hRes)) {
		i = nRet = 0;
		pItem = lpGrp->pItems;
		while (pItem) {
			pItem->hServer = pItemResult[i].hServer;
			pItem->vtSrvrType = pItemResult[i].vtCanonicalDataType;
			pItem->bReadable =  (pItemResult[i].dwAccessRights & OPC_READABLE) ? 1 : 0;
			pItem->bWriteable =  (pItemResult[i].dwAccessRights & OPC_WRITEABLE) ? 1 : 0;
			if (pItem->bReadable) {
				if (pErrors[i] == S_OK) {
					bOK = FALSE;
					switch (pItem->vtSrvrType) {
					case VT_BSTR:
					case VT_LPSTR:
					case VT_LPWSTR:
						bOK = (pItem->vtClntType == VTC_STR) || (pItem->vtClntType == VTC_WSTR);
						break;
					case VT_BOOL:
					case VT_INT:
					case VT_I1:
					case VT_I2:
					case VT_I4:
					case VT_UI1:
					case VT_UI2:
					case VT_UI4:
					case VT_UINT:
						bOK = (pItem->vtClntType == VTC_BOOL) || (pItem->vtClntType == VTC_INT32) || (pItem->vtClntType == VTC_UINT32);
						break;
					case VT_I8:
						bOK = pItem->vtClntType == VTC_INT64;
						break;
					case VT_UI8:
						bOK = pItem->vtClntType == VTC_UINT64;
						break;
					case VT_R4:
					case VT_R8:
					case VT_DATE:
						bOK = pItem->vtClntType == VTC_DOUBLE;
						break;
					}
					if (!bOK) nRet = OPCERR_UNSUPPORTEDTYPE;
				}
				else nRet = OPCERR_ADDITEM;
			}
			else nRet = OPCERR_ITEMUNREADABLE;
			pItem = pItem->pNext;
			i++;
		}
	}
	else nRet = OPCERR_ADDITEM;
	CoTaskMemFree(pItemResult);
	CoTaskMemFree(pErrors);
	FreeMem((LPVOID) pItemDef);
	FreeMem((LPVOID) pName);
	return nRet;
}
// **********************************************************************************
INT32 __stdcall OPC_Start(LPOPCSERVER lpSrvr) {
typedef	IOPCServerList	*LPIOPCSERVERLIST;
COSERVERINFO		CoSrvrInfo;
LPIOPCSERVERLIST	pSrvrList;
MULTI_QI			MultiQI;
CLSID				clsid;
HRESULT				hRes;
INT32				nLen, nHostLen, nRet;
LPWSTR				pHost, pName;
LPOPCGROUP			pGrp;
LONG				nTimeBias;
FLOAT				fDeadBand;
DWORD				nUpdateRate;
BOOL				bActive;
LPUNKNOWN			pUnk;
LPCONPOINTCONT		pCPC;

	if (!lpSrvr) return OPCERR_SERVERNONE;
	if (lpSrvr->bActive) return OPCERR_SERVERSTARTED;
	if (!lpSrvr->nGrpCnt) return OPCERR_NOGROUPDEFINED;
	if (!lpSrvr->nItemCnt) return OPCERR_NOITEMDEFINED;
	if (!COM_Init()) return OPCERR_COINITIALIZE;
	lpSrvr->bActive = lpSrvr->bComInit = 1;
	nLen = StrLen(lpSrvr->pServer);
	pName = (LPWSTR) GetMem(GMM_CLEAR, (nLen + 1) << 1);
	AnsiToWideChar(pName, lpSrvr->pServer, nLen, WCTA_LE);
	nHostLen = StrLen(lpSrvr->pHost);
	if (nHostLen) {
		MemClr(&CoSrvrInfo, sizeof(CoSrvrInfo));
		pHost = (LPWSTR) GetMem(GMM_CLEAR, (nHostLen + 1) << 1);
		AnsiToWideChar(pHost, lpSrvr->pHost, nHostLen, WCTA_LE);
		CoSrvrInfo.pwszName = pHost;
		MemClr(&MultiQI, sizeof(MultiQI));
		MultiQI.pIID = &IID_IOPCServerList;
		hRes = CoCreateInstanceEx (CLSID_OPCServerList, NULL, CLSCTX_SERVER, &CoSrvrInfo, 1, &MultiQI);
		pSrvrList = (LPIOPCSERVERLIST) MultiQI.pItf;
		if ((hRes == S_OK) && (MultiQI.hr == S_OK) && (pSrvrList))	{
			hRes = pSrvrList->CLSIDFromProgID(pName, &clsid);
		}
		else {
			if (hRes == S_OK) hRes = S_FALSE;
		}
		if (pSrvrList)pSrvrList->Release();
	}
	else {
		pHost = NULL;
		hRes = CLSIDFromProgID(pName, &clsid);
	}
	FreeMem((LPVOID) pName);
	nRet = OPCERR_NONE;
	if (hRes == S_OK)	{
		MemClr(&MultiQI, sizeof(MultiQI));
		MultiQI.pIID = &IID_IOPCServer;
		if (nHostLen) {
			hRes = CoCreateInstanceEx(clsid, NULL, CLSCTX_SERVER, &CoSrvrInfo, 1, &MultiQI);
		}
		else {
			hRes = CoCreateInstanceEx(clsid, NULL, CLSCTX_SERVER, NULL, 1, &MultiQI); 
		}
		lpSrvr->pIOPCServer = (LPIOPCSERVER) MultiQI.pItf;
		if ((hRes == S_OK) && (MultiQI.hr == S_OK) && (lpSrvr->pIOPCServer)) {
			nTimeBias = 0;
			fDeadBand = 0.0;
			pGrp = lpSrvr->pGroups;
			while (pGrp) {
				pGrp->bRateChanged = pGrp->bConnected = pGrp->bActive = 0;
				nLen = StrLen(pGrp->cName);
				pName = (LPWSTR) GetMem(GMM_CLEAR, (nLen + 1) << 1);
				AnsiToWideChar(pName, pGrp->cName, nLen, WCTA_LE);
				hRes = lpSrvr->pIOPCServer->AddGroup(pName, FALSE, pGrp->nUpdateRate, pGrp->hClient, &nTimeBias, &fDeadBand, LOCALE_ID,
														&pGrp->hServer, &nUpdateRate, IID_IOPCItemMgt, (LPUNKNOWN *) &pGrp->pIOPCItemMgt);
				FreeMem((LPVOID) pName);
				if (SUCCEEDED(hRes)) {
					if (hRes == OPC_S_UNSUPPORTEDRATE) {
						pGrp->nUpdateRate = nUpdateRate;
						pGrp->bRateChanged = 1;
					}
					nRet = pAddItems(pGrp);
				}
				else nRet = OPCERR_ADDGROUP;
				if (nRet) break;		// while (pGrp)
				hRes = pGrp->pIOPCItemMgt->QueryInterface(IID_IOPCGroupStateMgt, (LPVOID *) &pGrp->pIOPCGroupStateMgt);
				if (hRes == S_OK) {
					pGrp->pCallBack = new COPCCallBack();
					pGrp->pCallBack->Connect(pGrp);
					hRes = pGrp->pCallBack->QueryInterface(IID_IUnknown, (LPVOID *) &pUnk);
					if (hRes == S_OK) {
						if (pGrp->bSyncRead) {
							hRes = pGrp->pIOPCItemMgt->QueryInterface(IID_IOPCSyncIO, (LPVOID *) &pGrp->pIOPCSyncIO);
							if (hRes != S_OK) nRet = OPCERR_GETSYNCIO;
						}
						else {
							hRes = pGrp->pIOPCItemMgt->QueryInterface(IID_IOPCAsyncIO2, (LPVOID *) &pGrp->pIOPCAsyncIO2);
							if (hRes == S_OK) {
								hRes = pGrp->pIOPCGroupStateMgt->QueryInterface(__uuidof(IConnectionPointContainer), (LPVOID *) &pCPC);
								if (hRes == S_OK) {
									hRes = pCPC->FindConnectionPoint(IID_IOPCDataCallback, &pGrp->pConPt);
									if (hRes == S_OK) {
										hRes = pGrp->pConPt->Advise((LPUNKNOWN) pGrp->pCallBack, &pGrp->nAdvise);
									}
									pCPC->Release();
								}
								if (hRes != S_OK) nRet = OPCERR_ADVISE;
							}
							else nRet = OPCERR_GETASYNCIO;
						}
					}
					else nRet = OPCERR_INTERNAL;
				}
				else nRet = OPCERR_GRPSTATEMGT;
				if (nRet) break;		// while (pGrp)
				bActive = TRUE;
				hRes =	pGrp->pIOPCGroupStateMgt->SetState(NULL, &nUpdateRate, &bActive, NULL, NULL, NULL, NULL);
				if (hRes == S_OK) {
					pGrp->bActive = 1;
				}
				else {
					nRet = OPCERR_ACTIVATE;
					break;				// while (pGrp)
				}
				pGrp = pGrp->pNext;
			}
		}
		else nRet = OPCERR_CREATESERVER;
	}
	else nRet = OPCERR_GETCLSID;
	FreeMem((LPVOID) pHost);
	if (nRet) OPC_Stop(lpSrvr);
	return nRet;
}
// **********************************************************************************
BOOL __stdcall OPC_ServerReady(LPOPCSERVER lpSrvr) {
LPOPCSERVERSTATUS	pStatus;
HRESULT				hRes;

	if (!lpSrvr) return FALSE;
	if (!lpSrvr->bActive) return FALSE;
	pStatus = NULL;
	hRes = lpSrvr->pIOPCServer->GetStatus(&pStatus);
	CoTaskMemFree(pStatus);
	return hRes == S_OK;
}
