/********************************************************************
 * Copyright (c) 2019 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - opc_stop.cpp											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#define _SYS_GUID_OPERATORS_
#include "OpcError.h"
#include "opcda.h"
#include <skclib32.h>
#include <sklibopc.h>

// **********************************************************************************
INT32 __stdcall OPC_Stop(LPOPCSERVER lpSrvr) {
HRESULT						hRes;
INT32						nItems, nSize;
LPOPCGROUP					pGrp;
LPOPCITEM					pItem;
LPOPCHANDLE					pHandles;
LPHRESULT					pErrors;
DWORD						nUpdateRate;
BOOL						bActive;

	if (!lpSrvr) return OPCERR_SERVERNONE;
	if (!lpSrvr->bActive) return OPCERR_SERVERSTOPPED;
	if (lpSrvr->pIOPCServer) {
		pGrp = lpSrvr->pGroups;
		while (pGrp) {
			if (pGrp->pIOPCItemMgt) {
				if (pGrp->pIOPCGroupStateMgt) {
					if (pGrp->bActive) {
						bActive = FALSE;
						hRes =	pGrp->pIOPCGroupStateMgt->SetState(NULL, &nUpdateRate, &bActive, NULL, NULL, NULL, NULL);
					}
					pGrp->pIOPCGroupStateMgt->Release();
					pGrp->pIOPCGroupStateMgt = NULL;
					if (pGrp->bSyncRead) {
						if (pGrp->pIOPCSyncIO) {
							pGrp->pIOPCSyncIO->Release();
							pGrp->pIOPCSyncIO = NULL;
						}
					}
					else {
						if (pGrp->nAdvise) {
							hRes = pGrp->pConPt->Unadvise(pGrp->nAdvise);
							pGrp->nAdvise = 0;
						}
						if (pGrp->pConPt) {
							pGrp->pConPt->Release();
							pGrp->pConPt = NULL;
						}
						if (pGrp->pIOPCAsyncIO2) {
							pGrp->pIOPCAsyncIO2->Release();
							pGrp->pIOPCAsyncIO2 = NULL;
						}
					}
					if (pGrp->pCallBack) pGrp->pCallBack->Release();
					if (pGrp->bConnected) delete pGrp->pCallBack;
					pGrp->pCallBack = NULL;
				}
				if (pGrp->nItemCnt) {
					pHandles = (LPOPCHANDLE) GetMem(GMM_CLEAR, pGrp->nItemCnt * sizeof(OPCHANDLE));
					nItems = 0;
					pItem = pGrp->pItems;
					while (pItem) {
						if (pItem->hServer) {
							pHandles[nItems] = pItem->hServer;
							nItems++;
						}
						pItem->hServer = 0;
						pItem->bReadable = pItem->bWriteable = pItem->bWrRequest = 0;
						if (pItem->bAllocated) {
							nSize = pItem->nMaxStrLen + 1;
							if (pItem->vtClntType == VTC_WSTR) nSize <<= 1;
							MemClr(pItem->Value.pStr, nSize);
						}
						else {
							MemClr(&pItem->Value, sizeof(OPCVALUE));
						}
						pItem = pItem->pNext;
					}
					if (nItems) {
						pErrors = NULL;
						hRes = pGrp->pIOPCItemMgt->RemoveItems(nItems, pHandles, &pErrors);
						CoTaskMemFree(pErrors);
					}
					FreeMem((LPVOID) pHandles);
				}
				pGrp->pIOPCItemMgt->Release();
				pGrp->pIOPCItemMgt = NULL;
				hRes = lpSrvr->pIOPCServer->RemoveGroup(pGrp->hServer, TRUE);
				pGrp->hServer = NULL;
			}
			pGrp->bRateChanged = pGrp->bConnected = pGrp->bActive = 0;
			pGrp = pGrp->pNext;
		}
		lpSrvr->pIOPCServer->Release();
		lpSrvr->pIOPCServer = NULL;
	}
	COM_Done(lpSrvr->bComInit);
	lpSrvr->bComInit = lpSrvr->bActive = 0;
	return OPCERR_NONE;
}
