/********************************************************************
 * Copyright (c) 2019 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - opc_callback.cpp										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#define _SYS_GUID_OPERATORS_
#include "OpcError.h"
#include "opcda.h"
#include <skclib32.h>
#include <sklibopc.h>

// **********************************************************************************
//// ItemID used in this sample
const LPWSTR	szItemID0 = L"TestVar1";    // this item must be readable and writeablein this sample
const LPWSTR	szItemID1 = L"TestVar2";    // this item must be readable in this sample

const DWORD		vtDataTypeItem0 = VT_EMPTY;		// canonical datatype
const DWORD		vtDataTypeItem1 = VT_UI2;		// unsigned integer 2 Bytes

INT32		m_ReadVal;
INT32		m_WriteVal;
HRESULT		m_ReadResult;
HRESULT		m_WriteResult;
UINT32		m_Quality0;
UINT32		m_Quality1;
FILETIME	m_TimeStamp0;
FILETIME	m_TimeStamp1;

LPIOPCSERVER			m_pIOPCServer;
LPIOPCITEMMGT			m_pIOPCItemMgt;
LPIOPCGROUPSSTATEMGT	m_pIOPCGroupStateMgt;
LPIOPCSYNCIO			m_pIOPCSyncIO;
OPCITEMDEF				m_Items[2];
LPOPCITEMRESULT			m_pItemResult;
OPCHANDLE				m_GrpSrvHandle;
LPHRESULT				m_pErrors;
LPIOPCASYNCIO2			m_pIOPCAsyncIO2;
DWORD					m_dwAdvise;

//	This handler is for OPC:
//	- retrieves the value of the item from the dialog
//	- initiates an sync write request
void Sync_Write() {	
OPCHANDLE		*phServer;
HRESULT			*pErrors;
VARIANT			values[1];
HRESULT			r1;

//	Select item by server handle received at AddItem
	phServer = new OPCHANDLE[1];
	phServer[0] = m_pItemResult[0].hServer;
//	Set Variant with datatype and received value
	values[0].vt = VT_I2;
	values[0].iVal = m_WriteVal;
	r1 = m_pIOPCSyncIO->Write(1, phServer, values, &pErrors);
	delete[] phServer;

	if (SUCCEEDED(r1)) {
		m_WriteResult = pErrors[0];
		CoTaskMemFree(pErrors);		
	}
}
static UINT32	m_nTransID		= 0;
static DWORD	m_nCancelID		= 0;
// **********************************************************************************
INT32 __stdcall OPC_Write(LPOPCSERVER lpSrvr, UINT32 nGrpID) {
LPOPCGROUP		pGrp;
LPOPCITEM		pItem, *phClients;
LPOPCHANDLE		phServers;
LPVARIANT		pValues;
INT32			i, nItems, nRet, nLen;
LPWSTR			pWStr;
HRESULT			hRes, hAct;
LPHRESULT		pErrors;
	
	if (!lpSrvr) return OPCERR_SERVERNONE;
	if (!lpSrvr->bActive) return OPCERR_SERVERSTOPPED;
	pGrp = OPC_GetGroup(lpSrvr, nGrpID);
	if (!pGrp) return OPCERR_GROUPNOTEXISTS;
	if (!pGrp->nItemCnt) return OPCERR_EMPTYGROUP;
	phServers = (LPOPCHANDLE) GetMem(GMM_CLEAR, pGrp->nItemCnt * (sizeof(OPCHANDLE) + sizeof(LPOPCITEM) + sizeof(VARIANT)));
	phClients = (LPOPCITEM *) &phServers[pGrp->nItemCnt];
	pValues = (LPVARIANT) &phClients[pGrp->nItemCnt];
	pItem = pGrp->pItems;
	nItems = 0;
	while (pItem) {
		if (pItem->bWrRequest) {
			phServers[nItems] = pItem->hServer;
			phClients[nItems] = pItem;
			pValues[nItems].vt = pItem->vtSrvrType;
			switch (pItem->vtSrvrType) {
			case VT_BSTR:
			case VT_LPSTR:
			case VT_LPWSTR:
				if (pItem->vtClntType == VTC_STR) {
					nLen = StrLen(pItem->Value.pStr);
					pWStr = (LPWSTR) GetMem(GMM_CLEAR, (nLen + 1) << 1);
					AnsiToWideChar(pWStr, pItem->Value.pStr, nLen, WCTA_LE);
				}
				else pWStr = pItem->Value.pWStr;
				pValues[nItems].vt = VT_BSTR;
				pValues[nItems].bstrVal = SysAllocStringLen(pWStr, nLen);
				if (pWStr != pItem->Value.pWStr) FreeMem((LPVOID) pWStr);
				break;
			case VT_BOOL:
				pValues[nItems].boolVal = (pItem->Value.b) ? -1 : 0;
				break;
			case VT_I1:
				pValues[nItems].cVal = (INT8) pItem->Value.i32;
				break;
			case VT_I2:
				pValues[nItems].iVal = (INT16) pItem->Value.i32;
				break;
			case VT_I4:
			case VT_INT:
				pValues[nItems].intVal = pItem->Value.i32;
				break;
			case VT_I8:
				pValues[nItems].llVal = pItem->Value.i64;
				break;
			case VT_UI1:
				pValues[nItems].bVal = (UINT8) pItem->Value.u32;
				break;
			case VT_UI2:
				pValues[nItems].uiVal = (UINT16) pItem->Value.u32;
				break;
			case VT_UI4:
			case VT_UINT:
				pValues[nItems].uintVal = pItem->Value.u32;
				break;
			case VT_UI8:
				pValues[nItems].ullVal = pItem->Value.u64;
				break;
				break;
			case VT_R4:
				pValues[nItems].fltVal = (FLOAT) pItem->Value.d;
				break;
			case VT_DATE:
			case VT_R8:
				pValues[nItems].dblVal = pItem->Value.d;
				break;
			}
			nItems++;
		}
		pItem = pItem->pNext;
	}
	nRet = OPCERR_NONE;
	if (nItems) {
		pErrors = NULL;
		if (pGrp->bSyncRead) {
			hRes = pGrp->pIOPCSyncIO->Write(nItems, phServers, pValues, &pErrors);
		}
		else {
			m_nTransID++;
			hRes = pGrp->pIOPCAsyncIO2->Write(nItems, phServers, pValues, m_nTransID, &m_nCancelID, &pErrors);
		}
		if (hRes != S_OK) nRet = OPCERR_WRITEFAILED;
		for (i = 0; i < nItems; i++) {
			pItem = phClients[i];
			pItem->bWrRequest = 0;
			if (pItem->bAllocated) SysFreeString(pValues[i].bstrVal);
			if ((hRes != S_OK) || pGrp->bSyncRead) {
				hAct = (pErrors) ? pErrors[i] : hRes;
				pGrp->pCallBack->ClearWriteRequest(pItem, hAct);
			}
		}
		CoTaskMemFree(pErrors);
	}
	FreeMem((LPVOID) phServers);
	return nRet;
}
