/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - ringbuffer.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>

// **********************************************************************************
BOOL __stdcall RingBuffer_Init(LPRINGBUFFER lpRB, INT32 nCount, INT32 nUnit) {
#define RB_MINCOUNT		8

	if ((nUnit < RBU_BYTE1) || (nUnit > RBU_BYTE8) || (nCount < RB_MINCOUNT) || !lpRB) return FALSE;
	MemClr(lpRB, sizeof(RINGBUFFER));
	lpRB->nUnit = nUnit;
	if (lpRB->pBuf.pVoid = GetMem(GMM_CLEAR, nCount << nUnit)) lpRB->nMaxCnt = nCount;
	return lpRB->pBuf.pVoid != NULL;
}
// **********************************************************************************
void __stdcall RingBuffer_Done(LPRINGBUFFER lpRB) {

	if (lpRB) {
		FreeMem(lpRB->pBuf.pVoid);
		MemClr(lpRB, sizeof(RINGBUFFER));
	}
}
// **********************************************************************************
void __stdcall RingBuffer_Clear(LPRINGBUFFER lpRB, INT32 nLock) {

	if (lpRB) {
		if (nLock) LockThread(nLock);
		lpRB->nRdIdx = lpRB->nWrIdx = 0;
		if (nLock) UnLockThread(nLock);
	}
}
// **********************************************************************************
INT32 __stdcall RingBuffer_Count(LPRINGBUFFER lpRB, INT32 nLock) {
INT32	nRet;

	if (lpRB) {
		if (nLock) LockThread(nLock);
		nRet = lpRB->nWrIdx - lpRB->nRdIdx;
		if (nRet < 0) nRet += lpRB->nMaxCnt;
		if (nLock) UnLockThread(nLock);
	}
	else nRet = 0;
	return nRet;
}
// **********************************************************************************
INT32 __stdcall RingBuffer_Read(LPRINGBUFFER lpRB, LPVOID lpDst, INT32 nCount, INT32 nLock) {
ANYPOINTER	pDst;
INT32		nRet;

	nRet = 0;
	if (lpRB && lpRB->nMaxCnt) {
		if (nLock) LockThread(nLock);
		pDst.pVoid = lpDst;
		while ((nRet < nCount) && (lpRB->nRdIdx != lpRB->nWrIdx)) {
			switch (lpRB->nUnit) {
			case RBU_BYTE2:
				pDst.pU16[nRet] = lpRB->pBuf.pU16[lpRB->nRdIdx];
				break;
			case RBU_BYTE4:
				pDst.pU32[nRet] = lpRB->pBuf.pU32[lpRB->nRdIdx];
				break;
			case RBU_BYTE8:
				pDst.pU64[nRet] = lpRB->pBuf.pU64[lpRB->nRdIdx];
				break;
			default:
				pDst.pU8[nRet] = lpRB->pBuf.pU8[lpRB->nRdIdx];
			}
			nRet++;
			lpRB->nRdIdx++;
			if (lpRB->nRdIdx == lpRB->nMaxCnt) lpRB->nRdIdx = 0;
		}
		if (nLock) UnLockThread(nLock);
	}
	return nRet;
}
// **********************************************************************************
INT32 __stdcall RingBuffer_Write(LPRINGBUFFER lpRB, LPVOID lpSrc, INT32 nCount, INT32 nLock) {
ANYPOINTER	pSrc;
INT32		nRet, nWrNext;

	nRet = 0;
	if (lpRB && lpRB->nMaxCnt) {
		if (nLock) LockThread(nLock);
		pSrc.pVoid = lpSrc;
		while (nRet < nCount) {
			nWrNext = lpRB->nWrIdx + 1;
			if (nWrNext == lpRB->nMaxCnt) nWrNext = 0;
			if (nWrNext == lpRB->nRdIdx) break;
			else {
				switch (lpRB->nUnit) {
				case RBU_BYTE2:
					lpRB->pBuf.pU16[lpRB->nWrIdx] = pSrc.pU16[nRet];
					break;
				case RBU_BYTE4:
					lpRB->pBuf.pU32[lpRB->nWrIdx] = pSrc.pU32[nRet];
					break;
				case RBU_BYTE8:
					lpRB->pBuf.pU64[lpRB->nWrIdx] = pSrc.pU64[nRet];
					break;
				default:
					lpRB->pBuf.pU8[lpRB->nWrIdx] = pSrc.pU8[nRet];
				}
				nRet++;
				lpRB->nWrIdx = nWrNext;
			}
		}
		if (nLock) UnLockThread(nLock);
	}
	return nRet;
}
