/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - rstutils.c												*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
BOOL __stdcall ReStartExists(LPSTR lpReStart) {
char	cFile[MAX_PATH], cName[MAX_PATH], cDefName[MAX_PATH];

	StrXCpy(cDefName, STR_RESTART, STR_EXT_EXE);
	GetIniFile(cFile);
	GetIniFileStr(cFile, STR_RESTART, STR_PROGRAM, cName, sizeof(cName), cDefName);
	FExpand(cFile, cName, NULL, FALSE);
	StrCpy(lpReStart, cFile);
	return FileExists(cFile, TRUE);
}
// **********************************************************************************
BOOL __stdcall DoReStart(LPSTR lpCmdLine) {
char	cReStart[MAX_PATH], cRstDir[MAX_PATH], cParam[1024];
INT32	nPos, nLen, nMax;
BOOL	bRet;

	if (bRet = ReStartExists(cReStart)) {
		FSplit(TRUE, cRstDir, NULL, cReStart);
		cParam[0] = 0;
		nLen = StrLen(cRstDir);
		nMax = 3;
		while (nLen && nMax) {
			nPos = StrInStr(g_cProgName, cRstDir, 0, TRUE);
			if (nPos == 0) break;
			nMax--;
			StrCat(cParam, STR_DBLDOTBSLASH);
			nLen = 1 + ChrInStrRev(cRstDir, '\\', nLen - 2, FALSE);
			cRstDir[nLen] = '\0';
		}
		if ((nPos == 0) && (CheckFolderName(cRstDir) >= CPR_VALID)) {
			nLen = StrLen(cRstDir);
		}
		else {
			nLen = 0;
			cParam[0] = 0;
		}
		StrCatN(cParam, &g_cProgName[nLen], sizeof(cParam));
		if (StrLen(lpCmdLine)) MultiCatN(sizeof(cParam), cParam, NULL, STR_SPACE, lpCmdLine, NULL);
		bRet = CreateSimpleProcess(cReStart, cParam);
	}
	return bRet;
}
// **********************************************************************************
BOOL __stdcall TestReStart(LPSTR lpCmdLine) {
char	cIniFile[MAX_PATH];
BOOL	bRet;

	GetIniFile(cIniFile);
	bRet = GetIniFileInt(cIniFile, STR_RESTART, STR_RESTART, 0, 1, 0);
	if (bRet) bRet = DoReStart(lpCmdLine);
	return bRet;
}
