/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_chkpath.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include <sklibudp.h>

// **********************************************************************************
INT32 __stdcall SKDP_ShareRoot(LPSTR lpRoot) {

	return MultiCat(lpRoot, STR_DBLBACKSLASH, g_SKDPInfo.UsrInf.cPCName, STR_BACKSLASH, NULL);
}
// **********************************************************************************
INT32 __stdcall SKDP_DefaultFolder(LPSKDPJOB lpJob, LPSTR lpFolder) {
LPSKDPSHAREINFO	pInfo;
LPSTR			pPath;

	pPath = Sort_Item(g_SKDPInfo.pShareList, lpJob->nDirs.b[0]);
	pInfo = (LPSKDPSHAREINFO) (pPath - sizeof(SKDPSHAREINFO));
	return MultiCat(lpFolder, STR_DBLBACKSLASH, g_SKDPInfo.UsrInf.cPCName, STR_BACKSLASH, pInfo->cName, STR_BACKSLASH, NULL);
}
// **********************************************************************************
INT32 __stdcall SKDP_CheckPath(LPSKDPJOB lpJob, LPSTR lpLoc, LPSTR lpRem, LPSTR lpPath, LPINT32 lpRights, INT32 nFlags) {
LPSKDPSHAREINFO	pShare;
LPSTR			pPath;
char			cRoot[MAX_PATH], cRemote[MAX_PATH], cFolder[MAX_PATH], cName[MAX_PATH];
INT32			i, j, k, n, nRet, nRights;

	nRet = nRights = 0;
	StrCpy(cRemote, lpPath);
	if (lpLoc) lpLoc[0] = 0;
	SKDP_DefaultFolder(lpJob, cRoot);
	j = FExpand(cRemote, cRemote, cRoot, TRUE);
	StrCpy(lpRem, cRemote);
	if (j) {
		k = SKDP_ShareRoot(cRoot);
		n = StrInStrRev(cRemote, cRoot, 0, TRUE);
		if (!n) {
			nRet = SKDPERR_INVALIDFOLDER;
			if (j == k) {
				if (nFlags & SKDP_CPF_FIND) {
					nRights = SKDP_SR_READ;
					nRet = 0;
				}
			}
			else {
				n = ChrInStr(cRemote, '\\', k, j, FALSE);
				StrCpyN(cRoot, &cRemote[k], n - k + 1);
				for (i = 0; i < lpJob->nDirCnt; i++) {
					pPath = Sort_Item(g_SKDPInfo.pShareList, lpJob->nDirs.b[i]);
					pShare = (LPSKDPSHAREINFO) (pPath - sizeof(SKDPSHAREINFO));
					if (!StrICmp(pShare->cName, cRoot)) {
						nRights = pShare->nFlags & (SKDP_SR_READ | SKDP_SR_WRITE | SKDP_SR_EXEC);
						if (lpJob->nConID >= 0) {
							j = 1 << lpJob->nConID;
							if (pShare->nConRead & j) nRights |= SKDP_SR_READ;
							if (pShare->nConWrite & j) nRights |= SKDP_SR_WRITE;
							if (pShare->nConExec & j) nRights |= SKDP_SR_EXEC;
						}
						StrXCpy(lpLoc, pPath, &cRemote[n + 1]);
						nRet = 0;
						if (nFlags & SKDP_CPF_FILE) {
							FSplit(TRUE, cFolder, cName, lpLoc);
							if (CheckFileName(cName) == CPR_VALID) pPath = cFolder;
							else nRet = SKDPERR_BADFILENAME;
						}
						else if (nFlags & SKDP_CPF_FOLDER) {
							FormatFolder(lpLoc, TRUE);
							pPath = lpLoc;
						}
						else pPath =  NULL;
						if (!nRet && pPath) {
							if (CheckFolderName(pPath) < CPR_VALID) nRet = SKDPERR_BADFOLDERNAME;
						}
						if (!nRet && (nFlags & SKDP_CPF_EXISTS)) {
							if (pPath && !FolderExists(pPath)) nRet = SKDPERR_FOLDERNOTFOUND;
							if (!nRet && (nFlags & SKDP_CPF_FILE) && !FileExists(lpLoc, FALSE)) nRet = SKDPERR_FILENOTFOUND;
						}
						break;
					}
				}
			}
		}
		else nRet = SKDPERR_INVALIDSERVER;
	}
	else nRet = SKDPERR_INVALIDFOLDER;
	if (lpRights) *lpRights = nRights;
	return nRet;
}
