/********************************************************************
 * Copyright (c) 2011-17 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_createdata.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
static INT32 WINAPI MySndChkProc(LPSKDPJOB lpJob, INT32 nError) {
LPSKDPFILEIO		pFile;
union {
LPSKDPFILEINFO		pStd;
LPSKDPBIGFILEINFO	pBig;
LPSTR				pStr;
}					p;
INT32				nLen, nAttr, nSizeHi;

	pFile = (LPSKDPFILEIO) lpJob->pResult;
	if (!nError && pFile) {
		p.pStr = lpJob->pRcvData;
		if ((nAttr = p.pStd->nAttr) & FA_BIGFILE) {
			nLen = sizeof(SKDPBIGFILEINFO);
			nSizeHi = p.pBig->nSizeHi;
			nAttr &= ~FA_BIGFILE;
		}
		else {
			nLen = sizeof(SKDPFILEINFO);
			nSizeHi = 0;
		}
		if (nLen == lpJob->nRcvLen) {
			pFile->nSizeLo = p.pStd->nSize;
			pFile->nSizeHi = nSizeHi;
		}
		else nError = SKDPERR_INVALIDDATA;
	}
	lpJob->bTskRdy = TRUE;
	return nError;
}
// **********************************************************************************
INT32 __stdcall SKDP_CreateData(LPSKDPJOB lpJob, INT32 nRetry, LPVOID lpHdr, INT32 nHdrSize, INT32 nClrSize, LPSKDPFILEIO lpFile, BOOL bCreate) {
ANYPOINTER		pAny;
INT32			nRet;


	LockThread(_SKDP_LOCK);
	nRet = SKDP_JobValid(lpJob, TRUE);
	if (!nRet) {
		lpJob->pResult = lpFile;
		pAny.pStr = lpJob->cData;
		*pAny.pI32++ = nClrSize;
		*pAny.pU16++ = nHdrSize;
		*pAny.pU8++ = bCreate ? 1 : 0;
		pAny.pStr += SKDP_CpySndStr(pAny.pStr, lpFile->cName, CHRSET_AUTO | CHRSET_WIN, 1 + SKDP_MAXPATH);
		MemCpy(pAny.pStr, lpHdr, nHdrSize);
		nRet = SKDP_SendJob(lpJob, SKDPFC_CREATEDATA, pAny.pStr - lpJob->cData + nHdrSize, 0, g_SKDPInfo.nTOut_IO, MySndChkProc, nRetry, FALSE);
	}
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
