/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_createdir.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
INT32 SKDP_CreateDir(LPSKDPJOB lpJob, INT32 nRetry, LPSTR lpDir) {
INT32	nRet, nLen;

	LockThread(_SKDP_LOCK);
	nRet = SKDP_JobValid(lpJob, TRUE);
	if (!nRet) {
		nLen = SKDP_CpySndStr(lpJob->cData, lpDir, CHRSET_AUTO | CHRSET_WIN, 1 + SKDP_MAXPATH);
		nRet = SKDP_SendJob(lpJob, SKDPFC_FILEINFO, nLen, 1, g_SKDPInfo.nTOut_Std, SKDP_DefSndChkProc, nRetry, FALSE);
	}
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
