/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_dofileio.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
INT32 __stdcall pSKDP_DoFileIO(LPSKDPJOB lpJob) {
union {
LPSKDPFILEREQUEST	pRqst;
LPSTR				pStr;
}					pSrcHdr;
union {
LPSKDPOPENMODE		pOpen;
LPSKDPIOMODE		pIO;
LPSKDPBIGIOMODE		pBigIO;
LPSTR				pStr;
}					pSrc;
union {
LPSKDPFILEREPLY		pRply;
LPSTR				pStr;
}					pDstHdr;
union {
LPSKDPIOMODE		pIO;
LPSKDPBIGIOMODE		pBigIO;
LPSTR				pStr;
}					pDst;
LPFILEIO			pFile;
SYSTEMTIME			st;
LPSTR				pInpMax, pOutMax;
INT32				i, nErr, nFId, nRights, nMode, nFlags, nSize, nIOSize;
INT64				nSeek, nMax;
char				cLocale[MAX_PATH];


	nErr = 0;
	pInpMax = pSrcHdr.pStr = pSrc.pStr = lpJob->pRcvData;
	pInpMax += lpJob->nRcvLen;
	pSrc.pStr += sizeof(SKDPFILEREQUEST);
	if ((pSrcHdr.pRqst->nFlags & SKDP_IOF_READ) && (pSrcHdr.pRqst->nFlags & SKDP_IOF_WRITE)) return SKDPERR_INVALIDDATA;
	pOutMax = pDstHdr.pStr = pDst.pStr = lpJob->pSndData;
	pOutMax += pSrcHdr.pRqst->nFlags & SKDP_IOF_READ ? SKDP_MAXTRANSFERSIZE : SKDP_MAXDATASIZE;
	pDst.pStr += sizeof(SKDPFILEREPLY);
	pDstHdr.pRply->nBlocks = 0;
	pDstHdr.pRply->nFlags = pSrcHdr.pRqst->nFlags;
	pDstHdr.pRply->nReserved = pSrcHdr.pRqst->nReserved;
	nFId = pSrcHdr.pRqst->nHandle;
	if (nFId) {
		if (nFId > SKDP_MAXFILES) return SKDPERR_INVALIDHANDLE;
		pFile = lpJob->pFiles[nFId - 1];
		if (!pFile) return SKDPERR_INVALIDHANDLE;
	}
	else {
		if (!pSrcHdr.pRqst->nBlocks) return SKDPERR_INVALIDREQUEST;
		if (pSrcHdr.pRqst->nFlags & SKDP_IOF_OPEN) {
			nSize = pInpMax - pSrc.pStr - (sizeof(SKDPOPENMODE) - SKDP_MAXPATH);
			if (nSize >= SKDP_MINSTRSIZE) {
				nMode = pSrc.pOpen->nMode & (FOM_WRITE | FOM_REWRITE | FOM_SHARE);
				nFlags = nMode & (FOM_WRITE | FOM_REWRITE) ? SKDP_CPF_FILE : SKDP_CPF_FILE | SKDP_CPF_EXISTS;
				nSize = 1 + SKDP_CvtRcvStr(&pSrc.pOpen->nChrSet, CHRSET_AUTO, min(nSize, SKDP_MAXPATH) + 1, &nErr);
				if (nErr) return nErr;
				if (nErr = SKDP_CheckPath(lpJob, cLocale, NULL, pSrc.pOpen->cFile, &nRights, nFlags)) return nErr;
				if (!(nRights & SKDP_SR_READ) || ((nMode & (FOM_WRITE | FOM_REWRITE)) && !(nRights & SKDP_SR_WRITE))) return SKDPERR_RIGHTS;
				if (!(pSrcHdr.pRqst->nFlags & SKDP_IOF_CLOSE)) {
					for (i = 0; i < SKDP_MAXFILES; i++) {
						if (!lpJob->pFiles[i]) {
							nFId = i + 1;
							break;
						}
					}
					if (!nFId) return SKDPERR_TOOMUCHFILE;
				}
				pFile = FOpen(cLocale, nMode, NULL);
				if (pFile) {
					if (pFile->nErr) {
						FClose(pFile);
						return SKDPERR_CANTOPEN;
					}
					else {
						if (nFId) {
							lpJob->pFiles[nFId - 1] = pFile;
						}
						else {
							lpJob->pActFile = pFile;
						}
					}
				}
				else return SKDPERR_MEMORY;
			}
			else return SKDPERR_BADDATALEN;
		}
		else return SKDPERR_INVALIDREQUEST;
		pSrc.pStr += nSize + (sizeof(SKDPOPENMODE) - SKDP_MAXPATH);
		pSrcHdr.pRqst->nBlocks--;
	}
	nIOSize = pSrcHdr.pRqst->nFlags & SKDP_IOF_BIGFILE ? sizeof(SKDPBIGIOMODE) : sizeof(SKDPIOMODE);
	while (!nErr && pSrcHdr.pRqst->nBlocks--) {
		if (((pInpMax - pSrc.pStr) < nIOSize) || ((pOutMax - pDst.pStr) < nIOSize)) nErr = SKDPERR_INVALIDDATA;
		else {
			nMode = pSrc.pIO->nMode;
			if (nMode > FSM_TIME) nErr = SKDPERR_INVALIDDATA;
			else if (nMode == FSM_TIME) {
				pDst.pIO->nReserved = 0;
				pDst.pIO->nMode = nMode;
				if (pSrcHdr.pRqst->nFlags & SKDP_IOF_WRITE) {
					SKDPTimeToSysTime(&st, &pSrc.pIO->st);
					FSetTime(pFile, FT_LASTACCESS | FT_LASTWRITE, &st);
				}
				else {
					FGetTime(pFile, FT_LASTWRITE, &st);
				}
				SysTimeToSKDPTime(&pDst.pIO->st, &st);
				pSrc.pStr += nIOSize;
				pDst.pStr += nIOSize;
			}
			else {
				nSize = pSrc.pIO->nSize;
				nSeek = pSrcHdr.pRqst->nFlags & SKDP_IOF_BIGFILE ? pSrc.pBigIO->nSeek : pSrc.pIO->nSeek;
				pSrc.pStr += nIOSize;
				FSeek(pFile, nSeek, nMode);
				if (pFile->nErr) nErr = SKDPERR_SEEK;
				else {
					if (!nSize && (pSrcHdr.pRqst->nFlags & SKDP_IOF_READ)) {
						nSize = pOutMax - pDst.pStr - nIOSize;
						if (nSize < 0) nSize = 0;
						nMax = pFile->nSize - pFile->nPos;
						if (nMax < nSize) {
							nSize = (INT32) nMax;
							pSrcHdr.pRqst->nFlags |= SKDP_IOF_CLOSE;
						}
					}
					pDst.pIO->nMode = nMode;
					pDst.pIO->nSize = nSize;
					if (pSrcHdr.pRqst->nFlags & SKDP_IOF_BIGFILE) pDst.pBigIO->nSeek = pFile->nPos;
					else pDst.pIO->nSeek = pFile->nPosLo;
					pDst.pStr += nIOSize;
					if (pSrcHdr.pRqst->nFlags & SKDP_IOF_READ) {
						if ((pOutMax - pDst.pStr) < nSize) nErr = SKDPERR_INVALIDDATA;
						else {
							FRead(pFile, pDst.pStr, nSize);
							if (pFile->nErr) nErr = SKDPERR_READ;
							else {
								pDst.pStr += nSize;
								pDstHdr.pRply->nBlocks++;
							}
						}
					}
					else if (pSrcHdr.pRqst->nFlags & SKDP_IOF_WRITE) {
						if ((pInpMax - pSrc.pStr) < nSize) nErr = SKDPERR_INVALIDDATA;
						else {
							if (nSize) FWrite(pFile, pSrc.pStr, nSize);
							else FTruncate(pFile);
							if (pFile->nErr) nErr = SKDPERR_WRITE;
							else {
								pSrc.pStr += nSize;
								pDstHdr.pRply->nBlocks++;
							}
						}
					}
				}
			}
		}
	}
	pDstHdr.pRply->nSize = pFile->nSize;
	pDstHdr.pRply->nPos = pFile->nPos;
	if (pSrcHdr.pRqst->nFlags & SKDP_IOF_CLOSE) {
		FClose(pFile);
		if (nFId) {
			lpJob->pFiles[nFId - 1] = NULL;
			nFId = 0;
		}
		else {
			lpJob->pActFile = NULL;
		}
	}
	pDstHdr.pRply->nHandle = nFId;
	lpJob->nSndLen = pDst.pStr - pDstHdr.pStr;
	return nErr;
}
