/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_dofindfile.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
INT32 __stdcall pSKDP_DoFindFile(LPSKDPJOB lpJob) {
union {
LPSKDPFINDREQUEST	pRqst;
LPSKDPFINDREPLY		pRply;
LPSKDPBIGFILEINFO	pInfo;
LPSTR				pStr;
}					p, q, r;
LPSKDPSHAREINFO		pShare;
LPSTR				pPath, pMax, pTest;
FILEINFO			fi;
FILETIME			ft;
SYSTEMTIME			st;
INT32				i, nErr, nLen, nRights, nDelta;
char				cLoc[MAX_PATH], cRem[MAX_PATH];
BOOL				bOK, bAdd;

	p.pStr = lpJob->pRcvData;
	q.pStr = r.pStr = lpJob->pSndData;
	q.pStr += sizeof(SKDPFINDREPLY) - SKDP_MAXPATH;
	r.pRply->nBlk = p.pRqst->nBlk;
	r.pRply->nCnt = 0;
	r.pRply->bLast = FALSE;
	if (p.pRqst->nPkt > SKDP_MAXPACKETCOUNT) p.pRqst->nPkt = SKDP_MAXPACKETCOUNT;
	if (p.pRqst->nBlk == 0) {
		if (!p.pRqst->nPkt) return SKDPERR_INVALIDREQUEST;
		nLen = lpJob->nRcvLen - (sizeof(SKDPFINDREQUEST) - SKDP_MAXPATH);
		if (nLen >= SKDP_MINSTRSIZE) {
			if (lpJob->pFind) {
				if (lpJob->pFind->hFind != INVALID_HANDLE_VALUE) FindClose(lpJob->pFind->hFind);
				FreeMem(lpJob->pFind);
			}
			lpJob->pFind = GetMem(GMM_CLEAR, sizeof(SKDPFINDDATA));
			if (lpJob->pFind) {
				lpJob->pFind->hFind = INVALID_HANDLE_VALUE;
				lpJob->pFind->bDirs = p.pRqst->bDirs;
				lpJob->pFind->nChrSet = p.pRqst->nChrSet;
				nLen = SKDP_CvtRcvStr(p.pRqst->cPath, lpJob->pFind->nChrSet, min(nLen, SKDP_MAXPATH), &nErr);
				if (!nErr) {
					FSplit(TRUE, cRem, lpJob->pFind->cMask, p.pRqst->cPath);
					if (!lpJob->pFind->cMask[0]) StrCpy(lpJob->pFind->cMask, STR_STAR);
					for (i = 0; lpJob->pFind->cMask[i]; i++) {
						if (lpJob->pFind->cMask[i] == ';') lpJob->pFind->cMask[i] = 0;
					}
					lpJob->pFind->cMask[++i] = 0;
					nErr = SKDP_CheckPath(lpJob, cLoc, cRem, cRem, &nRights, SKDP_CPF_FIND | SKDP_CPF_FOLDER | SKDP_CPF_EXISTS);
					if (nErr) {
						FreeMemEx(&lpJob->pFind);
						return nErr;
					}
				}
			}
			else return SKDPERR_MEMORY;
		}
		else return SKDPERR_BADDATALEN;
		q.pStr += SKDP_CpySndStr(r.pRply->cPath, cRem, lpJob->pFind->nChrSet, SKDP_MAXPATH);
		if (cLoc[0]) {
			if (lpJob->pFind->bDirs) {
				r.pRply->nCnt++;
				GetFInfo(cLoc, &fi);
				SysTimeToSKDPTime(&q.pInfo->FileTime, &fi.Time);
				q.pInfo->nAttr = FA_DIRECTORY;
				q.pInfo->nSizeLo = 0;
				q.pStr += sizeof(SKDPFILEINFO);
				q.pStr += 1 + StrCpy(q.pStr, STR_PARENTDIR);
				if (fi.nType >= CPR_ROOT) lpJob->pFind->bIsCurrent = lpJob->pFind->bIsParent = TRUE;
			}
			StrCat(cLoc, STR_STAR);
			if (nRights & SKDP_SR_READ) lpJob->pFind->hFind = FindFirstFile(cLoc, &lpJob->pFind->wfd);
			if (lpJob->pFind->hFind == INVALID_HANDLE_VALUE) r.pRply->bLast = TRUE;
			else lpJob->pFind->bReady = TRUE;
		}
		else {
			r.pRply->bLast = TRUE;
			for (i = 0; i < lpJob->nDirCnt; i++) {
				r.pRply->nCnt++;
				pPath = Sort_Item(g_SKDPInfo.pShareList, lpJob->nDirs.b[i]);
				pShare = (LPSKDPSHAREINFO) (pPath - sizeof(SKDPSHAREINFO));
				GetFTime(pPath, FT_LASTWRITE, &st);
				SysTimeToSKDPTime(&q.pInfo->FileTime, &st);
				q.pInfo->nAttr = FA_DIRECTORY;
				q.pInfo->nSizeLo = 0;
				q.pStr += sizeof(SKDPFILEINFO);
				q.pStr += SKDP_CpySndStr(q.pStr, pShare->cName, lpJob->pFind->nChrSet, SKDP_MAXPATH);
			}
		}
	}
	else {
		if (lpJob->nRcvLen != sizeof(SKDPFINDHDR)) return SKDPERR_BADDATALEN;
		if (!p.pRqst->nPkt || !lpJob->pFind || (lpJob->pFind->nNextBlk != p.pRqst->nBlk)) return SKDPERR_INVALIDREQUEST;
	}
	r.pRply->nChrSet = lpJob->pFind->nChrSet;
	if (!r.pRply->bLast) {
		pMax = r.pStr + (p.pRqst->nPkt * SKDP_MAXDATASIZE);
		pTest = r.pStr + SKDP_MAXDATASIZE;
		do {
			if (!lpJob->pFind->bReady) {
				if (FindNextFile(lpJob->pFind->hFind, &lpJob->pFind->wfd)) lpJob->pFind->bReady = TRUE;
				else r.pRply->bLast = TRUE;
			}
			if (bOK = lpJob->pFind->bReady) {
				if (lpJob->pFind->wfd.dwFileAttributes & FA_UNKNOWN) lpJob->pFind->bReady = FALSE;
				else {
					bAdd = (lpJob->pFind->wfd.dwFileAttributes & FA_DIRECTORY) && lpJob->pFind->bDirs;
					if (bAdd) {
						if (!lpJob->pFind->bIsCurrent) {
							if (lpJob->pFind->bIsCurrent = StrCmp(lpJob->pFind->wfd.cFileName, STR_CURRENTDIR) == 0) bAdd = FALSE;
						}
						if (!lpJob->pFind->bIsParent) {
							if (lpJob->pFind->bIsParent = StrCmp(lpJob->pFind->wfd.cFileName, STR_PARENTDIR) == 0) bAdd = FALSE;
						}
					}
					else {
						pPath = lpJob->pFind->cMask;
						while ((nLen = StrLen(pPath)) && !bAdd) {
							bAdd = FNameMask(lpJob->pFind->wfd.cFileName, pPath);
							pPath += nLen + 1;
						}
					}
					if (bAdd) {
						nLen = 1 + StrLen(lpJob->pFind->wfd.cFileName);
						i = nLen + sizeof(SKDPBIGFILEINFO);
						if ((q.pStr + i) > pTest) {
							pTest += SKDP_MAXDATASIZE;
							nDelta = g_SKDPInfo.nTickCounter - lpJob->nTickStart;
							if (nDelta >= 5) pMax = q.pStr;
						}
						if ((q.pStr + i) <= pMax) {
							r.pRply->nCnt++;
							lpJob->pFind->bReady = FALSE;
							FileTimeToLocalFileTime(&lpJob->pFind->wfd.ftLastWriteTime, &ft);
							FileTimeToSystemTime(&ft, &st);
							SysTimeToSKDPTime(&q.pInfo->FileTime, &st);
							if (!(q.pInfo->nAttr = (UINT16) lpJob->pFind->wfd.dwFileAttributes)) q.pInfo->nAttr = FA_NORMAL;
							q.pInfo->nSizeLo = lpJob->pFind->wfd.nFileSizeLow;
							if (q.pInfo->nSizeHi = lpJob->pFind->wfd.nFileSizeHigh) {
								q.pInfo->nAttr |= FA_BIGFILE;
								q.pStr += sizeof(SKDPBIGFILEINFO);
							}
							else q.pStr += sizeof(SKDPFILEINFO);
							q.pStr += SKDP_CpySndStr(q.pStr, lpJob->pFind->wfd.cFileName, lpJob->pFind->nChrSet, SKDP_MAXPATH);
						}
						else {
							bOK = FALSE;
							lpJob->pFind->nNextBlk++;
						}
					}
					else lpJob->pFind->bReady = FALSE;
				}
			}
		} while (bOK);
	}
	if (r.pRply->bLast) {
		if (lpJob->pFind->hFind != INVALID_HANDLE_VALUE) FindClose(lpJob->pFind->hFind);
		FreeMemEx(&lpJob->pFind);
	}
	lpJob->nSndLen = q.pStr - r.pStr;
	return 0;
}
