/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_dosfvread.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
INT32 __stdcall pSKDP_DoSfvRead(LPSKDPJOB lpJob) {
union {
LPSKDPSFVREQUEST	pRqst;
LPSTR				pStr;
}					pSrc;
union {
LPSKDPSFVREPLY		pRply;
LPSTR				pStr;
}					pDst;
LPSTR				pName, pOut;
LPFILEIO			pFile;
FILEINFO			fi;
SYSTEMTIME			st;
BOOL				bRead, bChange;
INT32				nErr, nRights, nSfv;
char				cLocale[MAX_PATH];


	nErr = 0;
	pName = pSrc.pStr = lpJob->pRcvData;
	pName += sizeof(SKDPSFVREQUEST);
	pOut = pDst.pStr = lpJob->pSndData;
	pOut += sizeof(SKDPSFVREPLY);
	SKDP_CvtRcvStr(&pSrc.pRqst->nChrSet, CHRSET_AUTO, lpJob->nRcvLen - sizeof(SKDPSFVREQUEST) + 1, &nErr);
	if (nErr) return nErr;
	if (nErr = SKDP_CheckPath(lpJob, cLocale, NULL, pName, &nRights, SKDP_CPF_FILE | SKDP_CPF_EXISTS)) return nErr;
	if (!(nRights & SKDP_SR_READ)) return SKDPERR_RIGHTS;
	if (lpJob->nSysErr = GetFInfo(cLocale, &fi)) return SKDPERR_READ;
	if ((fi.nSize > SKDP_MAXSFVREAD) || (fi.nSize > pSrc.pRqst->nMaxSize)) return SKDPERR_TOOBIG;
	if (!(bRead = bChange = pSrc.pRqst->bFirst)) {
		SKDPTimeToSysTime(&st, &pSrc.pRqst->FTime);
		fi.Time.wDayOfWeek = 0;
		if (MemCmp(&fi.Time, &st, sizeof(SYSTEMTIME)) || (fi.nSize != pSrc.pRqst->nSize)) bRead = TRUE;
	}
	if (bRead) {
		lpJob->pActFile = pFile = FOpen(cLocale, FOM_READ | FOM_SHARE, NULL);
		if (pFile) {
			if (pFile->nErr) nErr = SKDPERR_CANTOPEN;
			else if (fi.nSize != pFile->nSize) nErr = SKDPERR_ACCESS;
			else {
				FRead(pFile, pOut, fi.nSizeLo);
				if (pFile->nErr) nErr = SKDPERR_READ;
			}
			FClose(pFile);
			lpJob->pActFile = NULL;
			if (nErr) return nErr;
		}
		else return SKDPERR_MEMORY;
		if (fi.nSizeLo) {
			nSfv = -1;
			Sfv_Calc(pOut, fi.nSizeLo, &nSfv);
			pDst.pRply->nSfv = ~nSfv;
		}
		else pDst.pRply->nSfv = 0;
		if (pSrc.pRqst->nSfv != pDst.pRply->nSfv) bChange = TRUE;
	}
	else pDst.pRply->nSfv = pSrc.pRqst->nSfv;
	pDst.pRply->nSize = fi.nSizeLo;
	SysTimeToSKDPTime(&pDst.pRply->FTime, &fi.Time);
	pDst.pRply->bReserved = 0;
	lpJob->nSndLen = sizeof(SKDPSFVREPLY);
	if (pDst.pRply->bChanged = bChange) lpJob->nSndLen += fi.nSizeLo;
	return 0;
}
