/********************************************************************
 * Copyright (c) 2011-17 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_fdelete.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
INT32 SKDP_FDelete(LPSKDPJOB lpJob, INT32 nRetry, LPSTR lpFileName) {
INT32	nRet, nLen;

	LockThread(_SKDP_LOCK);
	nRet = SKDP_JobValid(lpJob, TRUE);
	if (!nRet) {
		lpJob->cData[0] = 1;		// Always
		nLen = 1 + SKDP_CpySndStr(&lpJob->cData[1], lpFileName, CHRSET_AUTO | CHRSET_WIN, 1 + SKDP_MAXPATH);
		nRet = SKDP_SendJob(lpJob, SKDPFC_FILEDELETE, nLen, 1, g_SKDPInfo.nTOut_IO, SKDP_DefSndChkProc, nRetry, FALSE);
	}
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
