/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_frename.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
INT32 SKDP_FRename(LPSKDPJOB lpJob, INT32 nRetry, LPSTR lpSrcName, LPSTR lpDstName) {
INT32	nRet, nLen;

	LockThread(_SKDP_LOCK);
	nRet = SKDP_JobValid(lpJob, TRUE);
	if (!nRet) {
		lpJob->cData[0] = 1;		// Always
		nLen = 1 + SKDP_CpySndStr(&lpJob->cData[1], lpSrcName, CHRSET_AUTO | CHRSET_WIN, 1 + SKDP_MAXPATH);
		nLen += SKDP_CpySndStr(&lpJob->cData[nLen], lpDstName, CHRSET_WIN, SKDP_MAXPATH);
		nRet = SKDP_SendJob(lpJob, SKDPFC_FILERENAME, nLen, 1, g_SKDPInfo.nTOut_IO, SKDP_DefSndChkProc, nRetry, FALSE);
	}
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
