/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_fileinfo.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
static INT32 WINAPI MySndChkProc(LPSKDPJOB lpJob, INT32 nError) {
LPFILEINFO			pInfo;
union {
LPSKDPFILEINFO		pStd;
LPSKDPBIGFILEINFO	pBig;
LPSTR				pStr;
}					p;
INT32				nLen, nAttr, nSizeHi;

	pInfo = (LPFILEINFO) lpJob->pResult;
	if (!nError && pInfo) {
		p.pStr = lpJob->pRcvData;
		if ((nAttr = p.pStd->nAttr) & FA_BIGFILE) {
			nLen = sizeof(SKDPBIGFILEINFO);
			nSizeHi = p.pBig->nSizeHi;
			nAttr &= ~FA_BIGFILE;
		}
		else {
			nLen = sizeof(SKDPFILEINFO);
			nSizeHi = 0;
		}
		if (nLen == lpJob->nRcvLen) {
			SKDPTimeToSysTime(&pInfo->Time, &p.pStd->FileTime);
			pInfo->nSizeLo = p.pStd->nSize;
			pInfo->nSizeHi = nSizeHi;
			pInfo->nAttr = nAttr;
		}
		else nError = SKDPERR_INVALIDDATA;
	}
	lpJob->bTskRdy = TRUE;
	return nError;
}
// **********************************************************************************
INT32 SKDP_FileInfo(LPSKDPJOB lpJob, INT32 nRetry, LPSTR lpFileName, LPFILEINFO lpFileInfo) {
INT32	nRet, nLen;

	LockThread(_SKDP_LOCK);
	nRet = SKDP_JobValid(lpJob, TRUE);
	if (!nRet) {
		lpJob->pResult = lpFileInfo;
		MemClr(lpFileInfo, sizeof(FILEINFO));
		nLen = SKDP_CpySndStr(lpJob->cData, lpFileName, CHRSET_AUTO | CHRSET_WIN, 1 + SKDP_MAXPATH);
		nRet = SKDP_SendJob(lpJob, SKDPFC_FILEINFO, nLen, 1, g_SKDPInfo.nTOut_IO, MySndChkProc, nRetry, FALSE);
	}
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
