/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_fillversion.c									*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"
// **********************************************************************************
#define SKDP_VENDORSTR		"UDP Server 1.0"
#define SKDP_VERSIONHI		1
#define SKDP_VERSIONLO		0
#if (SKDP_MAXNAMESIZE < MAX_PCNAMESIZE) || (SKDP_MAXNAMESIZE < MAX_DOMAINNAMESIZE) || (SKDP_MAXNAMESIZE < MAX_USERNAMESIZE)
	#error Bad name size.
#endif
// **********************************************************************************
void __stdcall pSKDP_FillVersion(LPSKDPJOB lpJob, LPVOID lpVersion) {
#define MAXSIZE		256
LPSKDPVERSION		pVersion;
INT32				n;

	pVersion = (LPSKDPVERSION) lpVersion;
	MemClr(pVersion, sizeof(SKDPVERSION));
	StrCpy(pVersion->cComputer, g_SKDPInfo.UsrInf.cPCName);
	StrCpy(pVersion->cVendor, SKDP_VENDORSTR);
	n = StrCpy(pVersion->cUser, g_SKDPInfo.UsrInf.cDomainName);
	if (n) {
		pVersion->cUser[n] = '\\';
		StrCatN(pVersion->cUser, g_SKDPInfo.UsrInf.cUserName, SKDP_MAXNAMESIZE);
	}
	else StrCpy(pVersion->cUser, g_SKDPInfo.UsrInf.cUserName);
	pVersion->nVersionHi = SKDP_VERSIONHI;
	pVersion->nVersionLo = SKDP_VERSIONLO;
	pVersion->nUDPBlkSize = SKDP_MAXDATASIZE;
	pVersion->nMaxUDPBlk = SKDP_MAXPACKETCOUNT;
	pVersion->nMaxFile = SKDP_MAXFILES;
	pVersion->nChrSetLocal = CHRSET_WIN;
	pVersion->nChrSetRemote = CHRSET_ANY;
}
// **********************************************************************************
void __stdcall pSKDP_CvtVersion(LPSKDPJOB lpJob) {
LPSKDPVERSION	pVersion;
UINT8			nID;
INT32			nErr;

	pVersion = (LPSKDPVERSION) lpJob->pRcvData;
	nID = pVersion->nChrSetLocal;
	SKDP_CvtRcvStr(pVersion->cComputer, nID, sizeof(pVersion->cComputer), &nErr);
	SKDP_CvtRcvStr(pVersion->cVendor, nID, sizeof(pVersion->cVendor), &nErr);
	SKDP_CvtRcvStr(pVersion->cUser, nID, sizeof(pVersion->cUser), &nErr);
}
