/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_findfile.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
static INT32 WINAPI MySndChkProc(LPSKDPJOB lpJob, INT32 nError) {
union {
LPSKDPFINDHDR		pHdr;
LPSKDPFINDREPLY		pRply;
LPSKDPBIGFILEINFO	pInfo;
LPSTR				pStr;
}					p, q;
LPSTR				pMax;
LPSORTINFO			pSort;
FILEINFO			fi;
INT32				i, nLen;

	if (!nError) {
		pSort = lpJob->pResult;
		pMax = q.pStr = p.pStr = lpJob->pRcvData;
		pMax += lpJob->nRcvLen;
		q.pStr += sizeof(SKDPFINDREPLY) - SKDP_MAXPATH;
		if (!p.pRply->nBlk) {
			nLen = SKDP_CvtRcvStr(p.pRply->cPath, p.pRply->nChrSet, min(pMax - q.pStr, SKDP_MAXPATH), &nError);
			if (!nError) {
				FreeMem(pSort->pData);
				pSort->pData = NewStr(p.pRply->cPath, nLen);
				q.pStr += 1 + nLen;
			}
		}
		MemClr(&fi, sizeof(FILEINFO));
		for (i = 0; (i < p.pRply->nCnt) && !nError; i++) {
			nLen = pMax - q.pStr;
			if (nLen >= sizeof(SKDPFILEINFO)) {
				SKDPTimeToSysTime(&fi.Time, &q.pInfo->FileTime);
				fi.nSizeLo = q.pInfo->nSizeLo;
				if ((fi.nAttr = q.pInfo->nAttr) & FA_BIGFILE) {
					if (nLen >= sizeof(SKDPBIGFILEINFO)) {
						fi.nSizeHi = q.pInfo->nSizeHi;
						fi.nAttr &= ~FA_BIGFILE;
						q.pStr += sizeof(SKDPBIGFILEINFO);
					}
					else nError = SKDPERR_INVALIDDATA;
				}
				else q.pStr += sizeof(SKDPFILEINFO);
			}
			else nError = SKDPERR_INVALIDDATA;
			if (!nError) {
				nLen = 1 + SKDP_CvtRcvStr(q.pStr, p.pRply->nChrSet, min(pMax - q.pStr, SKDP_MAXPATH), &nError);
				if (!nError) {
					Sort_Add(pSort, q.pStr, &fi, TRUE, 0);
					q.pStr += nLen;
				}
			}
		}
		if (!nError) {
			if (p.pRply->bLast) lpJob->bTskRdy = TRUE;
			else {
				p.pStr = lpJob->cData;
				p.pHdr->nBlk++;
				p.pHdr->nPkt = SKDP_MAXPACKETCOUNT;
				SKDP_SendJob(lpJob, SKDPFC_FINDFILE, sizeof(SKDPFINDHDR), 0, g_SKDPInfo.nTOut_Find, NULL, -1, FALSE);
			}
		}
	}
	if (nError) lpJob->bTskRdy = TRUE;
	return nError;
}
// **********************************************************************************
INT32 SKDP_FindFile(LPSKDPJOB lpJob, LPSORTINFO lpSort, LPSTR lpFile, BOOL bDirs) {
union {
LPSKDPFINDREQUEST	pFindReq;
LPSTR				pStr;
}					p;
INT32				nRet, nLen;

	LockThread(_SKDP_LOCK);
	nRet = SKDP_JobValid(lpJob, TRUE);
	if (!nRet) {
		lpJob->pResult = lpSort;
		p.pStr = lpJob->cData;
		p.pFindReq->nBlk = 0;
		p.pFindReq->nPkt = SKDP_MAXPACKETCOUNT;
		p.pFindReq->bDirs = bDirs;
		p.pFindReq->nChrSet = CHRSET_WIN;
		nLen = SKDP_CpySndStr(p.pFindReq->cPath, lpFile, p.pFindReq->nChrSet, SKDP_MAXPATH) + 
				sizeof(SKDPFINDREQUEST) - SKDP_MAXPATH;
		nRet = SKDP_SendJob(lpJob, SKDPFC_FINDFILE, nLen, 0, g_SKDPInfo.nTOut_Find, MySndChkProc, -1, FALSE);
	}
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
