/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_findserver.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
INT32 SKDP_FindServer(LPSTR lpServer, UINT32 nIpVal, UINT32 nPort) {
INT32		nRet;

	LockThread(_SKDP_LOCK);
	g_SKDPInfo.pSPkt->Adr.nIp = nIpVal;
	g_SKDPInfo.pSPkt->Adr.nPort = nPort;
	SKDP_FillHeader(&g_SKDPInfo.pSPkt->Hdr, NULL, SKDPFC_SRVRFIND, 0, 1, 0, SKDPFL_BROADCAST, 0);
	g_SKDPInfo.pSPkt->cData[0] = CHRSET_WIN;
	g_SKDPInfo.pSPkt->nLen = StrCpyN(&g_SKDPInfo.pSPkt->cData[1], lpServer, SKDP_MAXNAMESIZE) + 2;
	nRet = SKDP_SendPacket(NULL, g_SKDPInfo.pSPkt, TRUE);
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
