/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_gettime.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
static INT32 WINAPI MySndChkProc(LPSKDPJOB lpJob, INT32 nError) {
LPSYSTEMTIME	pRem;
LPSKDPTIMEINFO	pTime;

	if (!nError) {
		pTime = (LPSKDPTIMEINFO) lpJob->pRcvData;
		if (pRem = lpJob->pResult) {
			pRem->wMilliseconds = pTime->nMSec;
			pRem->wDayOfWeek = pTime->nDoW;
			pRem->wSecond = pTime->nSec;
			pRem->wMinute = pTime->nMin;
			pRem->wHour = pTime->nHour;
			pRem->wDay = pTime->nDay;
			pRem->wMonth = pTime->nMonth;
			pRem->wYear = pTime->nYear;
		}
	}
	lpJob->bTskRdy = TRUE;
	return nError;
}
// **********************************************************************************
INT32 SKDP_GetTime(LPSKDPJOB lpJob, INT32 nRetry, BOOL bSystem, LPSYSTEMTIME lpResult) {
INT32	nRet, nLen;

	LockThread(_SKDP_LOCK);
	nRet = SKDP_JobValid(lpJob, TRUE);
	if (!nRet) {
		lpJob->pResult = lpResult;
		lpJob->nUser = 0;
		if (bSystem) {
			nLen = 1;
			lpJob->cData[0] = 1;
		}
		else nLen = 0;
		nRet = SKDP_SendJob(lpJob, SKDPFC_GETTIME, nLen, 1, g_SKDPInfo.nTOut_Std, MySndChkProc, nRetry, FALSE);
	}
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
