/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_main.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"
#include <ws2ipdef.h>

#pragma comment(lib, "ws2_32.lib")

// Default timeout values
#define MIN_TOUT_SEND		1				// millisec
#define DEF_TOUT_SEND		1
#define MAX_TOUT_SEND		20
#define MIN_TOUT_STD		1				// millisec
#define DEF_TOUT_STD		10
#define MAX_TOUT_STD		500
#define MIN_TOUT_RSND		1				// millisec
#define DEF_TOUT_RSND		5
#define MAX_TOUT_RSND		50
#define MIN_TOUT_IO			1				// millisec
#define DEF_TOUT_IO			50
#define MAX_TOUT_IO			2000
#define MIN_TOUT_FIND		1				// millisec
#define DEF_TOUT_FIND		200
#define MAX_TOUT_FIND		2000
#define MIN_TOUT_REQ		10				// sec
#define DEF_TOUT_REQ		30
#define MAX_TOUT_REQ		300
#define MIN_RETRY			0
#define DEF_RETRY			5
#define MAX_RETRY			30

SKDPINFO					g_SKDPInfo = {0};

// **********************************************************************************
static INT32 __stdcall pFindShareListID(INT32 nID) {
LPSKDPSHAREINFO	pInfo;
LPSTR			pPath;
INT32			i, nRet;

	nRet = -1;
	for (i = 0; i < g_SKDPInfo.pShareList->nCount; i++) {
		pPath = Sort_Item(g_SKDPInfo.pShareList, i);
		pInfo = (LPSKDPSHAREINFO) (pPath - sizeof(SKDPSHAREINFO));
		if (pInfo->nID == nID) {
			nRet = i;
			break;
		}
	}
	return nRet;
}
// **********************************************************************************
INT32 __stdcall SKDP_Init(HWND hWnd, INT32 nDbgMask, LPSTR lpIniFile, SKDPCALLBACK lpCallBack) {
SKDPSHAREINFO		Info;
HCURSOR				hOldCursor;
UINT32				nIp;
INT32				i, j, n, nConID, nResult, nPort;
BOOL				bOK;
SYSTEMTIME			st;
LPSKDPJOB			pJob;
union	{
LPVOID				pVoid;
LPSORTINFO			pSort;
LPSKDPPACKET		pPkt;
}					p;
LPSTR				pIniBuf;
char				cSection[64], cKey[64], cVal[MAX_PATH], cFolder[MAX_PATH];

	LockThread(_SKDP_LOCK);
// show the hourglass cursor
	hOldCursor = SetCursorFromResource(hWnd, NULL, IDC_WAIT);
	pIniBuf = LoadTextFile(lpIniFile, LTF_ADDCRLF, ABSMAX_INIFILESIZE, NULL);
	MemClr(&g_SKDPInfo, sizeof(SKDPINFO));
	g_SKDPInfo.nConnections = GetIniBufInt(pIniBuf, STR_UDP, STR_MAXCONNECTION, 1, SKDP_ABSMAXCONNECTION, SKDP_ABSMAXCONNECTION);
	p.pVoid = GetMem(GMM_CLEAR, 2 * sizeof(SKDPPACKET) + sizeof(SORTINFO));
	g_SKDPInfo.pShareList = p.pSort++;
	g_SKDPInfo.pRPkt = p.pPkt++;
	g_SKDPInfo.pSPkt = p.pPkt++;
	g_SKDPInfo.pConInfo = GetMem(GMM_CLEAR, g_SKDPInfo.nConnections * sizeof(SKDPCONINFO));
	if (g_SKDPInfo.pShareList && g_SKDPInfo.pConInfo) {
		Sort_Init(g_SKDPInfo.pShareList, 4096, ABSMAXSHARE, sizeof(SKDPSHAREINFO), NULL);
	}
	else {
		g_SKDPInfo.nError = SKDPERR_MEMORY;
	}
	if (!g_SKDPInfo.nError) {
		g_SKDPInfo.nSysLog = GetIniBufIP(pIniBuf, STR_UDP, STR_SYSLOG, 0);
		pSKDP_ReadSharedFolders(pIniBuf);
		pSKDP_ReadShareList(pIniBuf, STR_UDP, 0);
		nConID = 0;
		for (i = 0; i < g_SKDPInfo.nConnections; i++) {
			MemClr(&g_SKDPInfo.pConInfo[nConID], sizeof(SKDPCONINFO));
			StrPrint(cSection, "%s%d", STR_CONNECTION, i + 1);
			g_SKDPInfo.pConInfo[nConID].nIp = GetIniBufIP(pIniBuf, cSection, STR_IP, 0);
			n = GetIniBufStr(pIniBuf, cSection, STR_NAME, g_SKDPInfo.pConInfo[nConID].cName, SKDP_MAXNAMESIZE, NULL);
			if (g_SKDPInfo.pConInfo[nConID].nIp || n) {
				bOK = TRUE;
				for ( j = 0; j < nConID; j++) {
					if (g_SKDPInfo.pConInfo[nConID].nIp && (g_SKDPInfo.pConInfo[nConID].nIp == g_SKDPInfo.pConInfo[j].nIp)) {
						bOK = FALSE;
						break;
					}
					if (n && !StrICmp(g_SKDPInfo.pConInfo[nConID].cName, g_SKDPInfo.pConInfo[j].cName)) {
						bOK = FALSE;
						break;
					}
				}
				if (bOK) {
					if (g_SKDPInfo.nSysLog) g_SKDPInfo.pConInfo[nConID].nSysLog = GetIniBufInt(pIniBuf, cSection, STR_SYSLOG, 0, 2, 0);
					g_SKDPInfo.pConInfo[nConID].bRstCheck = GetIniBufInt(pIniBuf, cSection, STR_RSTCHECK, 0, 1, 0);
					if (g_SKDPInfo.pConInfo[nConID].bRstCheck) {
						g_SKDPInfo.pConInfo[nConID].nRstTime = 600;
						g_SKDPInfo.pConInfo[nConID].nRstMaxCnt = 3;
					}
					GetIniBufStr(pIniBuf, cSection, STR_RIGHTS, cVal, sizeof(cVal), NULL);
					n = ChrInStr(cVal, 'B', 0, MAX_SIGNED32, TRUE);
					if (n >= 0) g_SKDPInfo.pConInfo[nConID].nFlags = SKDP_CR_REBOOT;
					n = ChrInStr(cVal, 'Q', 0, MAX_SIGNED32, TRUE);
					if (n >= 0) g_SKDPInfo.pConInfo[nConID].nFlags |= SKDP_CR_QUIT;
					n = ChrInStr(cVal, 'S', 0, MAX_SIGNED32, TRUE);
					if (n >= 0) g_SKDPInfo.pConInfo[nConID].nFlags |= SKDP_CR_RESTART;
					n = ChrInStr(cVal, 'U', 0, MAX_SIGNED32, TRUE);
					if (n >= 0) g_SKDPInfo.pConInfo[nConID].nFlags |= SKDP_CR_UPDATE;
					pSKDP_ReadShareList(pIniBuf, cSection, nConID + 1);
					nConID++;
				}
			}
		}
		if (g_SKDPInfo.nConnections != nConID) {
			if (nConID) ModifyMemEx(&g_SKDPInfo.pConInfo, GMM_CLEAR, nConID * sizeof(SKDPCONINFO));
			else FreeMemEx(&g_SKDPInfo.pConInfo);
			g_SKDPInfo.nConnections = nConID;
		}
		if (!g_SKDPInfo.nDirCnt) {
			MemClr(&Info, sizeof(Info));
			g_SKDPInfo.nDirs.b[0] = Info.nID = g_SKDPInfo.pShareList->nCount;
			StrCpy(Info.cName, STR_DEFAULT);
			FSplit(TRUE, cFolder, NULL, g_cProgName);
			Sort_Add(g_SKDPInfo.pShareList, cFolder, &Info, TRUE, 1);
			g_SKDPInfo.nDirCnt++;
		}
		Sort_Finish(g_SKDPInfo.pShareList);
		for (j = 0; j < g_SKDPInfo.nDirCnt; j++) {
			g_SKDPInfo.nDirs.b[j] = pFindShareListID(g_SKDPInfo.nDirs.b[j]);
		}
		g_SKDPInfo.nDefDir = g_SKDPInfo.nDirs.b[0];
		for (i = 0; i < g_SKDPInfo.nConnections; i++) {
			if (!g_SKDPInfo.pConInfo[i].nDirCnt) {
				g_SKDPInfo.pConInfo[i].nDirs.b[0] = g_SKDPInfo.nDefDir;
				g_SKDPInfo.pConInfo[i].nDirCnt++;
			}
			else {
				for (j = 0; j < g_SKDPInfo.pConInfo[i].nDirCnt; j++) {
					g_SKDPInfo.pConInfo[i].nDirs.b[j] = pFindShareListID(g_SKDPInfo.pConInfo[i].nDirs.b[j]);
				}
			}
		}
		GetUserInfo(&g_SKDPInfo.UsrInf);
		n = GetIniBufStr(pIniBuf, STR_UDP, STR_PC, cVal, sizeof(cVal), NULL);
		if (n && StrICmp(cVal, g_SKDPInfo.UsrInf.cPCName)) g_SKDPInfo.nError = SKDPERR_PCNAME;
	}
	if (!g_SKDPInfo.nError) {
		nIp = GetIniBufIP(pIniBuf, STR_UDP, STR_IP, 0);
		nPort = GetIniBufInt(pIniBuf, STR_UDP, STR_PORT, 1024, 65535, SKDP_PORT);
		g_SKDPInfo.nError = OpenSocket(g_SKDPInfo.UsrInf.cPCName, nIp, nPort, SOCK_DGRAM, IPPROTO_UDP, TRUE, TRUE, 50, 50, &g_SKDPInfo.NetInf, &g_SKDPInfo.pSPkt->Adr, &g_SKDPInfo.nSysErr);
		for (i = 0; (i < SKDP_MAXEVENTS) && !g_SKDPInfo.nError; i++) {
			g_SKDPInfo.hEvents[i] = CreateEvent(0, TRUE, 0, 0);
			if (!g_SKDPInfo.hEvents[i]) g_SKDPInfo.nError = SKDPERR_CREATEEVENT;
		}
	}
	if (!g_SKDPInfo.nError) {
		nResult = WSAEventSelect(g_SKDPInfo.NetInf.nSkt, g_SKDPInfo.hEventPacket, FD_READ);
		if (nResult == SOCKET_ERROR) {
			g_SKDPInfo.nError = SKDPERR_EVENTSELECT;
			g_SKDPInfo.nSysErr = WSAGetLastError();
		}
		else {
			g_SKDPInfo.nMaxJob = GetIniBufInt(pIniBuf, STR_UDP, STR_MAXJOB, 4, SKDP_MAXJOB, SKDP_MAXJOB);
			g_SKDPInfo.nJobFree = g_SKDPInfo.nMaxJob == SKDP_MAXJOB ? -1 : ~(-1 << g_SKDPInfo.nMaxJob);
			for (i = 0; (i < g_SKDPInfo.nMaxJob) && !g_SKDPInfo.nError; i++) {
				pJob = g_SKDPInfo.pJobs[i] = GetMem(GMM_CLEAR, sizeof(SKDPJOB));
				if (pJob) {
					g_SKDPInfo.pJobs[i] = pJob;
					pJob->nClntIdx = i + 1;
					pJob->nFlags = SKDPFL_REPLY;
				}
				else g_SKDPInfo.nError = SKDPERR_MEMORY;
			}
		}
	}
	if (!g_SKDPInfo.nError) {
		StrPrint(cKey, "%s.%s", STR_TIMEOUT, STR_SEND);
		g_SKDPInfo.nTOut_Send = GetIniBufInt(pIniBuf, STR_UDP, cKey, MIN_TOUT_SEND, MAX_TOUT_SEND, DEF_TOUT_SEND);
		StrPrint(cKey, "%s.%s", STR_TIMEOUT, STR_STD);
		g_SKDPInfo.nTOut_Std = GetIniBufInt(pIniBuf, STR_UDP, cKey, MIN_TOUT_STD, MAX_TOUT_STD, DEF_TOUT_STD);
		StrPrint(cKey, "%s.%s", STR_TIMEOUT, STR_RESEND);
		g_SKDPInfo.nTOut_Resend = GetIniBufInt(pIniBuf, STR_UDP, cKey, MIN_TOUT_RSND, MAX_TOUT_RSND, DEF_TOUT_RSND);
		StrPrint(cKey, "%s.%s", STR_TIMEOUT, STR_IO);
		g_SKDPInfo.nTOut_IO = GetIniBufInt(pIniBuf, STR_UDP, cKey, MIN_TOUT_IO, MAX_TOUT_IO, DEF_TOUT_IO);
		StrPrint(cKey, "%s.%s", STR_TIMEOUT, STR_FIND);
		g_SKDPInfo.nTOut_Find = GetIniBufInt(pIniBuf, STR_UDP, cKey, MIN_TOUT_FIND, MAX_TOUT_FIND, DEF_TOUT_FIND);
		StrPrint(cKey, "%s.%s", STR_TIMEOUT, STR_REQ);
		g_SKDPInfo.nTOut_Req = 1000 * GetIniBufInt(pIniBuf, STR_UDP, cKey, MIN_TOUT_REQ, MAX_TOUT_REQ, DEF_TOUT_REQ);
		StrPrint(cKey, "%s.%s", STR_RETRY, STR_SEND);
		g_SKDPInfo.nSndRetry = GetIniBufInt(pIniBuf, STR_UDP, cKey, MIN_RETRY, MAX_RETRY, DEF_RETRY);
		StrPrint(cKey, "%s.%s", STR_RETRY, STR_RCV);
		g_SKDPInfo.nRcvRetry = GetIniBufInt(pIniBuf, STR_UDP, cKey, MIN_RETRY, MAX_RETRY, DEF_RETRY);
		GetLocalTime(&st);
		g_SKDPInfo.nTickCounter = 1000 * TimeToSec(&st) + st.wMilliseconds;
		g_SKDPInfo.nTimerID = FastTimer_Init((LPINT32) &g_SKDPInfo.nTickCounter, 0, NULL, 1, pSKDP_TimerProc, NULL);
		for (i = 0; i < g_SKDPInfo.nConnections; i++) {
			if (g_SKDPInfo.pConInfo[i].nSysLog) {
				g_SKDPInfo.pConInfo[i].nLastTick = g_SKDPInfo.nTickCounter;
				g_SKDPInfo.pConInfo[i].nState = g_SKDPInfo.pConInfo[i].nLogState = SKDP_CS_UNKNOWN;
			}
			else {
				g_SKDPInfo.pConInfo[i].nState = g_SKDPInfo.pConInfo[i].nLogState = SKDP_CS_DONTCARE;
			}
		}
		g_SKDPInfo.pCallBack = lpCallBack;
		g_SKDPInfo.nDebug = nDbgMask;
		g_SKDPInfo.hMainWnd = hWnd;
		g_SKDPInfo.bActive = TRUE;
		if (!(g_SKDPInfo.hThread = SimpleThread(pSKDP_ThreadProc, NULL))) g_SKDPInfo.nError = SKDPERR_THREADSTART;
	}
	FreeMem(pIniBuf);
	SetCursorFromHandle(hWnd, hOldCursor);						// restore cursor
	UnLockThread(_SKDP_LOCK);
	return g_SKDPInfo.nError;
}
// **********************************************************************************
void __stdcall SKDP_Done() {
HCURSOR		hOldCursor;
INT32		i;

	hOldCursor = SetCursorFromResource(g_SKDPInfo.hMainWnd, NULL, IDC_WAIT);
	g_SKDPInfo.bActive = FALSE;
	if (g_SKDPInfo.hThread) {
		SetEvent(g_SKDPInfo.hEventTimeOut);
		WaitForZero(&g_SKDPInfo.hThread, 1000);
	}
	if (g_SKDPInfo.hThread) {
		TerminateThread(g_SKDPInfo.hThread, -1);
	}
	LockThread(_SKDP_LOCK);
	if (g_SKDPInfo.nTimerID) {
		FastTimer_Done(g_SKDPInfo.nTimerID);
	}
	for (i = 0; i < SKDP_MAXEVENTS; i++) {
		if (g_SKDPInfo.hEvents[i]) {
			ResetEvent(g_SKDPInfo.hEvents[i]);
			CloseHandle(g_SKDPInfo.hEvents[i]);
		}
	}
	CloseSocket(g_SKDPInfo.NetInf.nSkt, g_SKDPInfo.NetInf.bWSA);
	for (i = 0; i < g_SKDPInfo.nMaxJob; i++) {
		SKDP_FreeJob(g_SKDPInfo.pJobs[i]);
		FreeMem(g_SKDPInfo.pJobs[i]);
	}
	FreeMem(g_SKDPInfo.pConInfo);
	Sort_Done(g_SKDPInfo.pShareList);
	FreeMem(g_SKDPInfo.pShareList);
	SetCursorFromHandle(g_SKDPInfo.hMainWnd, hOldCursor);						// restore cursor
	MemClr(&g_SKDPInfo, sizeof(SKDPINFO));
	UnLockThread(_SKDP_LOCK);
}
