/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_message.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
INT32 SKDP_Message(LPSKDPJOB lpJob, LPSTR lpMsg, UINT32 nIpVal, UINT32 nPort) {
INT32		nRet, nLen;

	LockThread(_SKDP_LOCK);
	if (lpJob) {
		nIpVal = lpJob->sPkt.Adr.nIp;
		nPort = lpJob->sPkt.Adr.nPort;
	}
	if (!lpJob || SKDP_BroadCastIP(nIpVal)) {
		g_SKDPInfo.pSPkt->Adr.nIp = nIpVal;
		g_SKDPInfo.pSPkt->Adr.nPort = nPort;
		SKDP_FillHeader(&g_SKDPInfo.pSPkt->Hdr, NULL, SKDPFC_MESSAGE, 0, 1, 0, SKDPFL_BROADCAST, 0);
		g_SKDPInfo.pSPkt->nLen = SKDP_CpySndStr(g_SKDPInfo.pSPkt->cData, lpMsg, CHRSET_AUTO | CHRSET_WIN, SKDP_MAXDATASIZE);
		nRet = SKDP_SendPacket(NULL, g_SKDPInfo.pSPkt, TRUE);
	}
	else {
		nRet = SKDP_JobValid(lpJob, TRUE);
		if (!nRet) {
			nLen = SKDP_CpySndStr(lpJob->cData, lpMsg, CHRSET_AUTO | CHRSET_WIN, SKDP_MAXTRANSFERSIZE);
			nRet = SKDP_SendJob(lpJob, SKDPFC_MESSAGE, nLen, 1, g_SKDPInfo.nTOut_Std, SKDP_DefSndChkProc, -1, FALSE);
		}
	}
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
