/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_readfile.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
static INT32 WINAPI MySndChkProc(LPSKDPJOB lpJob, INT32 nError) {
LPSKDPFILEIO	pFile;
union {
LPSKDPFILEREPLY		pRply;
LPSTR				pStr;
}					pSrcHdr;
union {
LPSKDPIOMODE		pIO;
LPSKDPBIGIOMODE		pBigIO;
LPSTR				pStr;
}					pSrc;
LPSTR				pMax;
INT32				i, nIOSize, nSize;

	if (!nError) {
		pFile = lpJob->pResult;
		pMax = pSrcHdr.pStr = pSrc.pStr = lpJob->pRcvData;
		pFile->nHandle = pSrcHdr.pRply->nHandle;
		pFile->nPos = pSrcHdr.pRply->nPos;
		pFile->nSize = pSrcHdr.pRply->nSize;
		pSrc.pStr += sizeof(SKDPFILEREPLY);
		pMax += lpJob->nRcvLen;
		nIOSize = pSrcHdr.pRply->nFlags & SKDP_IOF_BIGFILE ? sizeof(SKDPBIGIOMODE) : sizeof(SKDPIOMODE);
		for (i = 0; i < pFile->nBlocks; i++) {
			if (pSrc.pIO->nMode == FSM_TIME) {
				if ((pFile->IO[i].nMode != FSM_TIME) || ((pSrc.pStr + nIOSize) > pMax)) nError = SKDPERR_INVALIDDATA;
				else SKDPTimeToSysTime(&pFile->IO[i].st, &pSrc.pIO->st);
				pSrc.pStr += nIOSize;
			}
			else {
				nSize = pSrc.pIO->nSize;
				pSrc.pStr += nIOSize;
				if ((pFile->IO[i].nSize && (pFile->IO[i].nSize != nSize)) || ((pSrc.pStr + nSize) > pMax)) nError = SKDPERR_INVALIDDATA;
				else {
					MemCpy(pFile->IO[i].pBuf, pSrc.pStr, nSize);
					pFile->IO[i].nSize = nSize;
					pSrc.pStr += nSize;
				}
			}
		}
	}
	lpJob->bTskRdy = TRUE;
	return nError;
}
// **********************************************************************************
INT32 __stdcall SKDP_ReadFile(LPSKDPJOB lpJob, INT32 nRetry, LPSKDPFILEIO lpFile, BOOL bBig, BOOL bClose) {
union {
LPSKDPFILEREQUEST	pRqst;
LPSTR				pStr;
}					pDstHdr;
union {
LPSKDPOPENMODE		pOpen;
LPSKDPIOMODE		pIO;
LPSKDPBIGIOMODE		pBigIO;
LPSTR				pStr;
}					pDst;
INT32				i, nIOSize, nRet;


	LockThread(_SKDP_LOCK);
	nRet = SKDP_JobValid(lpJob, TRUE);
	if (!nRet) {
		lpJob->pResult = lpFile;
		pDstHdr.pStr = pDst.pStr = lpJob->cData;
		pDst.pStr += sizeof(SKDPFILEREQUEST);
		pDstHdr.pRqst->nBlocks = pDstHdr.pRqst->nReserved = 0;
		pDstHdr.pRqst->nFlags = SKDP_IOF_READ;
		if (bBig) pDstHdr.pRqst->nFlags |= SKDP_IOF_BIGFILE;
		if (bClose) pDstHdr.pRqst->nFlags |= SKDP_IOF_CLOSE;
		if (!(pDstHdr.pRqst->nHandle = lpFile->nHandle)) {
			pDstHdr.pRqst->nFlags |= SKDP_IOF_OPEN;
			pDstHdr.pRqst->nBlocks++;
			pDst.pOpen->nMode = FOM_READ | FOM_SHARE;
			pDst.pOpen->nChrSet = CHRSET_WIN;
			pDst.pStr += SKDP_CpySndStr(pDst.pOpen->cFile, lpFile->cName, pDst.pOpen->nChrSet, SKDP_MAXPATH);
			pDst.pStr += sizeof(SKDPOPENMODE) - SKDP_MAXPATH;
		}
		nIOSize = bBig ? sizeof(SKDPBIGIOMODE) : sizeof(SKDPIOMODE);
		for (i = 0; i < lpFile->nBlocks; i++) {
			pDstHdr.pRqst->nBlocks++;
			pDst.pIO->nMode = lpFile->IO[i].nMode;
			if (lpFile->IO[i].nMode == FSM_TIME) {
				SysTimeToSKDPTime(&pDst.pIO->st, &lpFile->IO[i].st);
			}
			else {
				pDst.pIO->nSize = lpFile->IO[i].nSize;
				if (bBig) pDst.pBigIO->nSeek = lpFile->IO[i].nPos;
				else pDst.pIO->nSeek = (INT32) lpFile->IO[i].nPos;
			}
			pDst.pStr += nIOSize;
		}
		nRet = SKDP_SendJob(lpJob, SKDPFC_FILEIO, pDst.pStr - pDstHdr.pStr, 0, g_SKDPInfo.nTOut_IO, MySndChkProc, nRetry, FALSE);
	}
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
