/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_receive.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
INT32 __stdcall pSKDP_ConUpdate(LPSKDPJOB lpJob, LPSTR lpName, INT32 nIpVal) {
INT32	i, nID, nIdxIp, nIdxName;

	nID = nIdxIp = nIdxName = -1;
	if (StrLen(lpName)) {
		for (i = 0; i < g_SKDPInfo.nConnections; i++) {
			if (nIpVal == g_SKDPInfo.pConInfo[i].nIp) nIdxIp = i;
			if (!StrICmp(lpName, g_SKDPInfo.pConInfo[i].cName)) nIdxName = i;
		}
	}
	if ((nIdxIp >= 0) && (nIdxName < 0)) {
		nID = nIdxIp;
		StrCpy(g_SKDPInfo.pConInfo[nID].cName, lpName);
	}
	else if ((nIdxIp < 0) && (nIdxName >= 0)) {
		nID = nIdxName;
		g_SKDPInfo.pConInfo[nID].nIp = nIpVal;
	}
	else if ((nIdxIp >= 0) && (nIdxIp == nIdxName)) nID = nIdxIp;
	if (lpJob) lpJob->nConID = nID;
	return nID;
}
// **********************************************************************************
static INT32 pSKDP_DoServerDone() {
LPSKDPJOB	pJob;
INT32		i, nMask, nJobs, nID;

	nMask = 1;
	nJobs = ~g_SKDPInfo.nJobFree;
	for (i = 0; i < g_SKDPInfo.nMaxJob; i++) {
		if (nJobs & nMask) {
			pJob = g_SKDPInfo.pJobs[i];
			if (pJob->sPkt.Adr.nIp == g_SKDPInfo.pRPkt->Adr.nIp) {
				if (pJob->nFlags & SKDPFL_REPLY) {
					SKDP_FreeJob(pJob);
				}
				else if (g_SKDPInfo.nJobActive &nMask) {
					pJob->nRcvErr = SKDPERR_SERVERDOWN;
					pJob->bRcvRdy = TRUE;
					SetBit((LPVOID) &g_SKDPInfo.nJobActive, i, 0);
					SetBit((LPVOID) &g_SKDPInfo.nJobTimeOut, i, 0);
				}
			}
		}
		nMask <<= 1;
	}
	nID = -1;
	for (i = 0; (i < g_SKDPInfo.nConnections) && (nID < 0); i++) {
		if (g_SKDPInfo.pRPkt->Adr.nIp == g_SKDPInfo.pConInfo[i].nIp) nID = i;
	}
	return nID;
}
// **********************************************************************************
static void pSKDP_DoServerFind() {
INT32	nLen, nErr;

	nLen = SKDP_CvtRcvStr(g_SKDPInfo.pRPkt->cData, CHRSET_AUTO, min(SKDP_MAXNAMESIZE + 1, g_SKDPInfo.pRPkt->nLen), &nErr);
	if (!nErr) {
		if (g_SKDPInfo.pRPkt->Hdr.nFlags & SKDPFL_REPLY) {
			pSKDP_ConUpdate(NULL, &g_SKDPInfo.pRPkt->cData[1], g_SKDPInfo.pRPkt->Adr.nIp);
			pSKDP_Callback(SKDP_CB_FINDSRVR, 0, NULL, g_SKDPInfo.pRPkt);
		}
		else if (FNameMask(g_SKDPInfo.UsrInf.cPCName, &g_SKDPInfo.pRPkt->cData[1])) {
			SKDP_FillHeader(&g_SKDPInfo.pSPkt->Hdr, NULL, SKDPFC_SRVRFIND, 0, 1, 0, SKDPFL_REPLY, 0);
			g_SKDPInfo.pSPkt->Adr.nIp = g_SKDPInfo.pRPkt->Adr.nIp;
			g_SKDPInfo.pSPkt->Adr.nPort = g_SKDPInfo.pRPkt->Adr.nPort;
			g_SKDPInfo.pSPkt->nLen = SKDP_CpySndStr(g_SKDPInfo.pSPkt->cData, g_SKDPInfo.UsrInf.cPCName,
										CHRSET_AUTO | g_SKDPInfo.pRPkt->cData[0], SKDP_MAXNAMESIZE + 1);
			SKDP_SendPacket(NULL, g_SKDPInfo.pSPkt, TRUE);
		}
	}
}
// **********************************************************************************
static INT32 __stdcall pSKDP_GetConRights(LPSKDPJOB lpJob) {
INT32	i, nRet;

	if (lpJob->nConID < 0) {
		nRet = 0;
		for (i = 0; i < g_SKDPInfo.nConnections; i++) {
			if (g_SKDPInfo.pConInfo[i].nIp == lpJob->sPkt.Adr.nIp) {
				lpJob->nConID = i;
				nRet = g_SKDPInfo.pConInfo[i].nFlags;
				break;
			}
		}
	}
	else nRet = g_SKDPInfo.pConInfo[lpJob->nConID].nFlags;
	return nRet;
}
// **********************************************************************************
void pSKDP_Receive() {
SYSTEMTIME		st;
union {
LPSKDPVERSION	pVersion;
LPSKDPTIMEINFO	pTime;
LPSTR			pStr;
}				p;
LPSKDPJOB		pJob;
BOOL			bDaylight, bSysTime;
INT32			i, nFunc, nErr, nLen, nCon, nDay, nSec, nDelta;

	nLen = sizeof(SOCKETADDRESS);
	g_SKDPInfo.pRPkt->nLen = recvfrom(g_SKDPInfo.NetInf.nSkt, g_SKDPInfo.pRPkt->cUdp, UDP_MAXDATASIZE, 0, &g_SKDPInfo.pRPkt->Adr.sa, &nLen);
	if ((g_SKDPInfo.pRPkt->nLen == SOCKET_ERROR) || (g_SKDPInfo.pRPkt->Adr.nIp == g_SKDPInfo.NetInf.nIp)) return;
	pJob = pSKDP_FindJob(&nErr);
	nFunc = g_SKDPInfo.pRPkt->Hdr.nFunction;
	if (nErr) {
		if (!(nErr & SKDPERRFL_REJECT)) {
			SKDP_FillHeader(&g_SKDPInfo.pSPkt->Hdr, NULL, nFunc, 0, 1, 0, SKDPFL_REPLY, nErr);
			g_SKDPInfo.pSPkt->Adr.nIp = g_SKDPInfo.pRPkt->Adr.nIp;
			g_SKDPInfo.pSPkt->Adr.nPort = g_SKDPInfo.pRPkt->Adr.nPort;
			g_SKDPInfo.pSPkt->nLen = 0;
			nErr = SKDP_SendPacket(pJob, g_SKDPInfo.pSPkt, TRUE);
		}
	}
	else if (g_SKDPInfo.pRPkt->Hdr.nFlags & SKDPFL_RESEND) {
		SKDP_ResendJob(pJob, TRUE);
	}
	else {
		if (!pJob || (pJob->nReqID != pJob->nLastID)) {
			if (pJob) {
				if (pJob->pActFile) {
					FClose(pJob->pActFile);
					pJob->pActFile = NULL;
				}
				if (nFunc != SKDPFC_FILEIO) {
					for (i = 0; i < SKDP_MAXFILES; i++) {
						if (pJob->pFiles[i]) {
							FClose(pJob->pFiles[i]);
							pJob->pFiles[i] = NULL;
						}
					}
				}
			}
			switch (nFunc) {
			case SKDPFC_SRVRINIT:
				SKDP_CvtRcvStr(g_SKDPInfo.pRPkt->cData, CHRSET_AUTO, min(SKDP_MAXNAMESIZE + 1, g_SKDPInfo.pRPkt->nLen), &nErr);
				if (!nErr) {
					nCon = pSKDP_ConUpdate(NULL, &g_SKDPInfo.pRPkt->cData[1], g_SKDPInfo.pRPkt->Adr.nIp);
					if (nCon >= 0) {
						g_SKDPInfo.pConInfo[nCon].nState = SKDP_CS_READY;
						g_SKDPInfo.pConInfo[nCon].nLastTick = g_SKDPInfo.nTickCounter;
						if (g_SKDPInfo.pConInfo[nCon].nLogState != SKDP_CS_READY) {
							if (g_SKDPInfo.pConInfo[nCon].bRstCheck) {
								GetSystemTime(&st);
								nDay = DateToDay(STARTYEAR, &st);
								nSec = TimeToSec(&st);
								nDelta = nDay - g_SKDPInfo.pConInfo[nCon].nRstLastDay;
								if (nDelta > 2) nDelta = 2;
								nDelta = (nDelta * SECONDSOFDAY) + nSec - g_SKDPInfo.pConInfo[nCon].nRstLastSec;
								if ((nDelta < 0) || (nDelta > g_SKDPInfo.pConInfo[nCon].nRstTime)) {
									g_SKDPInfo.pConInfo[nCon].nRstLastDay = nDay;
									g_SKDPInfo.pConInfo[nCon].nRstLastSec = nSec;
									g_SKDPInfo.pConInfo[nCon].bRstError = FALSE;
									g_SKDPInfo.pConInfo[nCon].nRstActCnt = 1;
								}
								else {
									g_SKDPInfo.pConInfo[nCon].nRstActCnt++;
									if (g_SKDPInfo.pConInfo[nCon].nRstActCnt >= g_SKDPInfo.pConInfo[nCon].nRstMaxCnt) {
										g_SKDPInfo.pConInfo[nCon].bRstError = TRUE;
										pSKDP_Callback(SKDP_CB_STARTCHECK, nCon, NULL, g_SKDPInfo.pRPkt);
									}
								}
							}
							pSKDP_Callback(SKDP_CB_START, nCon, NULL, g_SKDPInfo.pRPkt);
						}
					}
				}
				break;
			case SKDPFC_SRVRDONE:
				nCon = pSKDP_DoServerDone();
				if (nCon >= 0) {
					g_SKDPInfo.pConInfo[nCon].nState = SKDP_CS_STOPPED;
					g_SKDPInfo.pConInfo[nCon].nLastTick = g_SKDPInfo.nTickCounter;
					if (g_SKDPInfo.pConInfo[nCon].nLogState != SKDP_CS_STOPPED) pSKDP_Callback(SKDP_CB_STOP, nCon, NULL, g_SKDPInfo.pRPkt);
				}
				break;
			case SKDPFC_SRVRFIND:
				pSKDP_DoServerFind();
				break;
			case SKDPFC_MESSAGE:
				pSKDP_Callback(SKDP_CB_MESSAGE, nErr, pJob, g_SKDPInfo.pRPkt);
				break;
			case SKDPFC_ENDREQUEST:
				SKDP_SendJob(pJob, -1, 0, 0, 0, NULL, -1, FALSE);
				SKDP_FreeJob(pJob);
				pJob = NULL;
				break;
			case SKDPFC_VERSION:
				pSKDP_CvtVersion(pJob);
				p.pStr = pJob->pRcvData;
				pSKDP_ConUpdate(pJob, p.pVersion->cComputer, pJob->sPkt.Adr.nIp);
				pSKDP_FillVersion(pJob, pJob->pSndData);
				pJob->nSndLen = sizeof(SKDPVERSION);
				break;
			case SKDPFC_GETTIME:
				p.pStr = pJob->pSndData;
				if (pJob->nRcvLen && pJob->pRcvData[0]) {
					GetSystemTime(&st);
					bDaylight = FALSE;
					bSysTime = TRUE;
				}
				else {
					bDaylight = GetTime(&st);
					bSysTime = FALSE;
				}
				p.pTime->nMSec =  st.wMilliseconds;
				p.pTime->nDoW = (UINT8) st.wDayOfWeek;
				if (bDaylight) p.pTime->nDoW |= 0x80;
				if (bSysTime) p.pTime->nDoW |= 0x40;
				p.pTime->nSec = (UINT8) st.wSecond;
				p.pTime->nMin = (UINT8) st.wMinute;
				p.pTime->nHour = (UINT8) st.wHour;
				p.pTime->nDay = (UINT8) st.wDay;
				p.pTime->nMonth = (UINT8) st.wMonth;
				p.pTime->nYear = st.wYear;
				pJob->nSndLen = sizeof(SKDPTIMEINFO);
				break;
			case SKDPFC_GETRIGHTS:
				pJob->nSndErr = SKDPERR_UNSUPPORTED;
				break;
			case SKDPFC_RESTART:
				if (pSKDP_GetConRights(pJob) & SKDP_CR_RESTART) {
					if (ReStartExists(NULL)) {
						SendNotifyMessage(g_SKDPInfo.hMainWnd, WM_SK_QUIT, 0, WM_SK_QUIT_LP_RESTART);
						if (g_SKDPInfo.bEnReStart) DoReStart(NULL);
					}
					else pJob->nSndErr = SKDPERR_FNIMPOSSIBLE;
				}
				else pJob->nSndErr = SKDPERR_FNDISABLED;
				break;
			case SKDPFC_REBOOT:
				if (pSKDP_GetConRights(pJob) & SKDP_CR_REBOOT) {
					SendNotifyMessage(g_SKDPInfo.hMainWnd, WM_SK_QUIT, 0, WM_SK_QUIT_LP_REBOOT);
					if (g_SKDPInfo.bEnReBoot) ShutdownWindows(TRUE, TRUE);
				}
				else pJob->nSndErr = SKDPERR_FNDISABLED;
				break;
			case SKDPFC_QUIT:
				pJob->nSndErr = SKDPERR_UNSUPPORTED;
				break;
			case SKDPFC_UPDATE:
				break;
			case SKDPFC_EXEC:
				pJob->nSndErr = SKDPERR_UNSUPPORTED;
				break;
			case SKDPFC_FINDFILE:
			case SKDPFC_DIRCREATE:
			case SKDPFC_DIRREMOVE:
			case SKDPFC_FILEINFO:
			case SKDPFC_SETFATTR:
			case SKDPFC_SETFDATE:
			case SKDPFC_FILERENAME:
			case SKDPFC_FILEDELETE:
			case SKDPFC_FILEIO:
			case SKDPFC_SFVREAD:
			case SKDPFC_CREATEDATA:
			case SKDPFC_READKEY:
			case SKDPFC_WRITEKEY:
				SetEvent(pJob->hEventUdp);
				pJob = NULL;
				break;
			default:
				pJob->nSndErr = SKDPERR_UNSUPPORTED;
				break;
			}
		}
		if (pJob) {
			pJob->nLastID = pJob->nReqID;
			SKDP_SendJob(pJob, -1, -1, 0, 0, NULL, -1, FALSE);
		}
	}	// if (nErr == SKDPERR_NONE)
}
