/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_send.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
INT32 WINAPI SKDP_DefSndChkProc(LPSKDPJOB lpJob, INT32 nError) {

	lpJob->bTskRdy = TRUE;
	return nError;
}
// **********************************************************************************
static INT32 pSKDP_DoDirCreate(LPSKDPJOB lpJob) {
INT32		nErr, nRights;
char		cLocale[MAX_PATH];

	SKDP_CvtRcvStr(lpJob->pRcvData, CHRSET_AUTO, min(SKDP_MAXPATH + 1, lpJob->nRcvLen), &nErr);
	if (!nErr) nErr = SKDP_CheckPath(lpJob, cLocale, NULL, &lpJob->pRcvData[1], &nRights, SKDP_CPF_FOLDER);
	if (!nErr) {
		if (nRights & SKDP_SR_WRITE) {
			nErr = CreateFolder(cLocale, &lpJob->nSysErr) ? 0 : SKDPERR_CANTCREATE;
		}
		else nErr = SKDPERR_RIGHTS;
	}
	return nErr;
}
// **********************************************************************************
static INT32 pSKDP_DoDirRemove(LPSKDPJOB lpJob) {
INT32		i, nErr, nRights;
LPSTR		pPath;
char		cLocale[MAX_PATH];
BOOL		bRoot;

	SKDP_CvtRcvStr(lpJob->pRcvData, CHRSET_AUTO, min(SKDP_MAXPATH + 1, lpJob->nRcvLen), &nErr);
	if (!nErr) nErr = SKDP_CheckPath(lpJob, cLocale, NULL, &lpJob->pRcvData[1], &nRights, SKDP_CPF_FOLDER | SKDP_CPF_EXISTS);
	if (!nErr) {
		if (nRights & SKDP_SR_WRITE) {
			bRoot = FALSE;
			for (i = 0; i < lpJob->nDirCnt; i++) {
				pPath = Sort_Item(g_SKDPInfo.pShareList, lpJob->nDirs.b[i]);
				if (!StrICmp(pPath, cLocale)) {
					bRoot = TRUE;
					break;
				}
			}
			FormatFolder(cLocale, FALSE);
			if (bRoot) nErr = SKDPERR_CANTDELETE;
			else if (!RemoveDirectory(cLocale)) {
				lpJob->nSysErr = GetLastError();
				nErr = SKDPERR_CANTDELETE;
			}
		}
		else nErr = SKDPERR_RIGHTS;
	}
	return nErr;
}
// **********************************************************************************
static INT32 __stdcall pSetFileInfo(LPSKDPJOB lpJob, LPSTR lpName) {
union {
LPSKDPBIGFILEINFO	pInfo;
LPSTR				pStr;
}					p;
FILEINFO			fi;
INT32				nErr;

	p.pStr = lpJob->pSndData;
	lpJob->nSysErr = GetFInfo(lpName, &fi);
	if (lpJob->nSysErr) nErr = SKDPERR_READ;
	else {
		nErr = 0;
		SysTimeToSKDPTime(&p.pInfo->FileTime, &fi.Time);
		if (!(p.pInfo->nAttr = (UINT16) fi.nAttr)) p.pInfo->nAttr = FA_NORMAL;
		p.pInfo->nSizeLo = fi.nSizeLo;
		if (p.pInfo->nSizeHi = fi.nSizeHi) {
			p.pInfo->nAttr |= FA_BIGFILE;
			lpJob->nSndLen = sizeof(SKDPBIGFILEINFO);
		}
		else lpJob->nSndLen = sizeof(SKDPFILEINFO);
	}
	return nErr;
}
// **********************************************************************************
static INT32 __stdcall pSKDP_DoFileInfo(LPSKDPJOB lpJob) {
INT32				nErr, nLen, nRights, nFlags;
char				cLocale[MAX_PATH];

	nLen = SKDP_CvtRcvStr(lpJob->pRcvData, CHRSET_AUTO, min(SKDP_MAXPATH + 1, lpJob->nRcvLen), &nErr);
	if (nErr) return nErr;
	nFlags = lpJob->pRcvData[nLen] == '\\' ? SKDP_CPF_FOLDER | SKDP_CPF_EXISTS : SKDP_CPF_FILE | SKDP_CPF_EXISTS;
	if (nErr = SKDP_CheckPath(lpJob, cLocale, NULL, &lpJob->pRcvData[1], &nRights, nFlags)) return nErr;
	if (nRights & SKDP_SR_READ) nErr = pSetFileInfo(lpJob, cLocale);
	else nErr = SKDPERR_RIGHTS;
	return nErr;
}
// **********************************************************************************
static INT32 __stdcall pSKDP_DoSetFAttr(LPSKDPJOB lpJob) {
ANYPOINTER	pAny;
char		cLocale[MAX_PATH];
INT32		nErr, nLen, nRights, nAttr, nFlags;

	pAny.pStr = lpJob->pRcvData;
	nAttr = *pAny.pU16++;
	nLen = SKDP_CvtRcvStr(pAny.pStr, CHRSET_AUTO, min(SKDP_MAXPATH + 1, lpJob->nRcvLen - 2), &nErr);
	if (nErr) return nErr;
	nFlags = pAny.pStr[nLen] == '\\' ? SKDP_CPF_FOLDER | SKDP_CPF_EXISTS : SKDP_CPF_FILE | SKDP_CPF_EXISTS;
	if (nErr = SKDP_CheckPath(lpJob, cLocale, NULL, ++pAny.pStr, &nRights, nFlags)) return nErr;
	if (nRights & SKDP_SR_WRITE) {
		if (!SetFileAttributes(pAny.pStr, nAttr)) {
			lpJob->nSysErr = GetLastError();
			nErr = SKDPERR_WRITE;
		}
	}
	else nErr = SKDPERR_RIGHTS;
	return nErr;
}
// **********************************************************************************
static INT32 __stdcall pSKDP_DoSetFDate(LPSKDPJOB lpJob) {
ANYPOINTER	pAny;
SYSTEMTIME	st;
LPFILEIO	pFile;
char		cLocale[MAX_PATH];
INT32		nErr, nLen, nRights;

	pAny.pStr = lpJob->pRcvData;
	SKDPTimeToSysTime(&st, pAny.pVoid);
	pAny.pStr += sizeof(SKDPTIME);
	nLen = SKDP_CvtRcvStr(pAny.pStr, CHRSET_AUTO, min(SKDP_MAXPATH + 1, lpJob->nRcvLen - sizeof(SKDPTIME)), &nErr);
	if (nErr) return nErr;
	if (nErr = SKDP_CheckPath(lpJob, cLocale, NULL, ++pAny.pStr, &nRights, SKDP_CPF_FILE | SKDP_CPF_EXISTS)) return nErr;
	if (nRights & SKDP_SR_WRITE) {
		lpJob->pActFile = pFile = FOpen(cLocale, FOM_WRITE | FOM_SHARE, NULL);
		if (pFile) {
			FSetTime(pFile, FT_LASTWRITE | FT_LASTACCESS, &st);
			if (nErr = FClose(pFile)) {
				lpJob->nSysErr = nErr;
				nErr = SKDPERR_WRITE;
			}
			lpJob->pActFile = NULL;
		}
	}
	else nErr = SKDPERR_RIGHTS;
	return nErr;
}
// **********************************************************************************
static INT32 __stdcall pSKDP_DoFileRename(LPSKDPJOB lpJob) {
char		cSrc[MAX_PATH], cDst[MAX_PATH];
INT32		nErr, nRights, nDst;
BOOL		bAlways;

	bAlways = lpJob->pRcvData[0];
	nDst = 3 + SKDP_CvtRcvStr(&lpJob->pRcvData[1], CHRSET_AUTO, min(SKDP_MAXPATH + 1, lpJob->nRcvLen - 3), &nErr);
	if (!nErr) nErr = SKDP_CheckPath(lpJob, cSrc, NULL, &lpJob->pRcvData[2], &nRights, SKDP_CPF_FILE | SKDP_CPF_EXISTS);
	if (!nErr) {
		SKDP_CvtRcvStr(&lpJob->pRcvData[nDst], lpJob->pRcvData[1], min(SKDP_MAXPATH, lpJob->nRcvLen - nDst), &nErr);
		if (!nErr) nErr = SKDP_CheckPath(lpJob, cDst, NULL, &lpJob->pRcvData[nDst], &nRights, SKDP_CPF_FILE);
		if (!nErr) {
			if (nRights & SKDP_SR_WRITE) {
				if (lpJob->nSysErr = FRename(cSrc, cDst, bAlways)) nErr = SKDPERR_CANTRENAME;
			}
			else nErr = SKDPERR_RIGHTS;
		}
	}
	return nErr;
}
// **********************************************************************************
static INT32 __stdcall pSKDP_DoFileDelete(LPSKDPJOB lpJob) {
char		cLocale[MAX_PATH];
INT32		nErr, nRights;
BOOL		bAlways;

	bAlways = lpJob->pRcvData[0];
	SKDP_CvtRcvStr(&lpJob->pRcvData[1], CHRSET_AUTO, min(SKDP_MAXPATH + 1, lpJob->nRcvLen - 1 ), &nErr);
	if (!nErr) nErr = SKDP_CheckPath(lpJob, cLocale, NULL, &lpJob->pRcvData[2], &nRights, SKDP_CPF_FILE | SKDP_CPF_EXISTS);
	if (!nErr) {
		if (nRights & SKDP_SR_WRITE) {
			if (lpJob->nSysErr = FDelete(cLocale, bAlways)) nErr = SKDPERR_CANTDELETE;
		}
		else nErr = SKDPERR_RIGHTS;
	}
	return nErr;
}
// **********************************************************************************
static INT32 pSKDP_DoCreateData(LPSKDPJOB lpJob) {
#define BUFFERSIZE		32768
ANYPOINTER		pAny;
LPSTR			pBuf;
char			cLocale[MAX_PATH], cFolder[MAX_PATH];
LPFILEIO		pFile;
BOOL			bCreate;
INT32			nErr, nRights, nHdrSize, nClrSize, nSize, nMode, nLen;

	pAny.pStr = lpJob->pRcvData;
	nClrSize = *pAny.pI32++;
	nHdrSize = *pAny.pU16++;
	bCreate = (*pAny.pU8++) ? TRUE : FALSE;
	nSize = lpJob->nRcvLen - nHdrSize - sizeof(INT32) - sizeof(UINT16) - sizeof(UINT8);
	nLen = 1 + SKDP_CvtRcvStr(pAny.pStr, CHRSET_AUTO, min(SKDP_MAXPATH + 1, nSize), &nErr);
	if ((nLen + 1) != nSize) return SKDPERR_INVALIDDATA;
	if (!nErr) nErr = SKDP_CheckPath(lpJob, cLocale, NULL, ++pAny.pStr, &nRights, SKDP_CPF_FILE);
	if (nErr) return nErr;
	pAny.pStr += nLen;
	if (nRights & SKDP_SR_WRITE) {
		FSplit(TRUE, cFolder, NULL, cLocale);
		if (CreateFolder(cFolder, NULL)) {
			nMode = bCreate ? FOM_REWRITE | FOM_SHARE : FOM_WRITE | FOM_SHARE;
			lpJob->pActFile = pFile = FOpen(cLocale, nMode, NULL);
			if (pFile) {
				if (pFile->nSize < (nHdrSize + nClrSize)) {
					pBuf = GetMem(GMM_CLEAR, BUFFERSIZE);
					FWrite(pFile, pAny.pStr, nHdrSize);
					while (nClrSize) {
						nSize = min(nClrSize, BUFFERSIZE);
						FWrite(pFile, pBuf, nSize);
						nClrSize -= nSize;
					}
					FreeMem(pBuf);
				}
				if (nErr = FClose(pFile)) {
					lpJob->nSysErr = nErr;
					nErr = SKDPERR_WRITE;
				}
				lpJob->pActFile = NULL;
			}
		}
		else nErr = SKDPERR_CANTCREATE;
	}
	else nErr = SKDPERR_RIGHTS;
	if (!nErr) nErr = pSetFileInfo(lpJob, cLocale);
	return nErr;
}
// **********************************************************************************
static INT32 __stdcall pSKDP_DoReadKey(LPSKDPJOB lpJob) {
char		cIni[MAX_PATH], cValue[SKDP_MAXSTRSIZE];
LPSTR		pSect, pKey;
INT32		nErr, nRights, n;

	n = 2 + SKDP_CvtRcvStr(lpJob->pRcvData, CHRSET_AUTO, min(SKDP_MAXPATH + 1, lpJob->nRcvLen - 2 * SKDP_MINSTRSIZE), &nErr);
	if (!nErr) nErr = SKDP_CheckPath(lpJob, cIni, NULL, &lpJob->pRcvData[1], &nRights, SKDP_CPF_FILE | SKDP_CPF_EXISTS);
	if (!nErr) {
		pSect = &lpJob->pRcvData[n];
		n += 1 + SKDP_CvtRcvStr(pSect, lpJob->pRcvData[1], min(SKDP_MAXSTRSIZE, lpJob->nRcvLen - n - SKDP_MINSTRSIZE), &nErr);
	}
	if (!nErr) {
		pKey = &lpJob->pRcvData[n];
		SKDP_CvtRcvStr(pKey, lpJob->pRcvData[1], min(SKDP_MAXSTRSIZE, lpJob->nRcvLen - n), &nErr);
	}
	if (!nErr) {
		if (nRights & SKDP_SR_READ) {
			n = GetIniFileStr(cIni, pSect, pKey, cValue, SKDP_MAXSTRSIZE, NULL);
		}
		else nErr = SKDPERR_RIGHTS;
	}
	if (nErr == SKDPERR_FILENOTFOUND) {
		nErr = 0;
		cValue[0] = 0;
	}
	if (!nErr) {
		lpJob->nSndLen = SKDP_CpySndStr(lpJob->pSndData, cValue, lpJob->pRcvData[1] | CHRSET_AUTO, SKDP_MAXSTRSIZE + 1);
	}
	return nErr;
}
// **********************************************************************************
static INT32 __stdcall pSKDP_DoWriteKey(LPSKDPJOB lpJob) {
char		cIni[MAX_PATH];
LPSTR		pSect, pKey, pVal;
INT32		nErr, nRights, n;

	n = 2 + SKDP_CvtRcvStr(lpJob->pRcvData, CHRSET_AUTO, min(SKDP_MAXPATH + 1, lpJob->nRcvLen - 3 * SKDP_MINSTRSIZE), &nErr);
	if (!nErr) nErr = SKDP_CheckPath(lpJob, cIni, NULL, &lpJob->pRcvData[1], &nRights, SKDP_CPF_FILE);
	if (!nErr) {
		pSect = &lpJob->pRcvData[n];
		n += 1 + SKDP_CvtRcvStr(pSect, lpJob->pRcvData[1], min(SKDP_MAXSTRSIZE, lpJob->nRcvLen - n - 2 * SKDP_MINSTRSIZE), &nErr);
	}
	if (!nErr) {
		pKey = &lpJob->pRcvData[n];
		n += 1 + SKDP_CvtRcvStr(pKey, lpJob->pRcvData[1], min(SKDP_MAXSTRSIZE, lpJob->nRcvLen - n - SKDP_MINSTRSIZE), &nErr);
	}
	if (!nErr) {
		pVal = &lpJob->pRcvData[n];
		SKDP_CvtRcvStr(pVal, lpJob->pRcvData[1], min(SKDP_MAXSTRSIZE, lpJob->nRcvLen - n), &nErr);
	}
	if (!nErr) {
		if (nRights & SKDP_SR_WRITE) SetIniFileStr(cIni, pSect, pKey, pVal);
		else nErr = SKDPERR_RIGHTS;
	}
	return nErr;
}
// **********************************************************************************
UINT32 __stdcall pJobThreadProc(LPSKDPJOB lpJob) {
SKDPSNDCHKPROC	pSndChk;
HWND			hWnd;
HANDLE			hEvent;
INT32			nErr, nWait, nRet, nPrior;
UINT32			nStart, nDelta;
BOOL			bQuit;

#ifdef _DEBUG
	DbgStrPrint("Udp job thread(0x%x) started.\r\n", _getptd()->nThreadID);
#endif	//	_DEBUG
	__try {
		nRet = 0;
		nPrior = (lpJob->nFlags & SKDPFL_REPLY) ? THREAD_PRIORITY_ABOVE_NORMAL : THREAD_PRIORITY_NORMAL;
		SetThreadPriority(_getptd()->hThread, nPrior);
		bQuit = FALSE;
		do {
			nWait = WaitForMultipleObjects(2, lpJob->hEvents, FALSE, INFINITE) - WAIT_OBJECT_0;
			switch (nWait) {
			case 0:
				ResetEvent(lpJob->hEventUdp);
				hWnd = lpJob->hUserWnd;
				hEvent = lpJob->hUserEvent;
				if (!(bQuit = lpJob->bQuit)) {
					if (lpJob->nFlags & SKDPFL_REPLY) {
						lpJob->nLastID = lpJob->nReqID;
						switch (lpJob->nFunction) {
						case SKDPFC_FINDFILE:
							lpJob->nSndErr = pSKDP_DoFindFile(lpJob);
							break;
						case SKDPFC_DIRCREATE:
							lpJob->nSndErr = pSKDP_DoDirCreate(lpJob);
							break;
						case SKDPFC_DIRREMOVE:
							lpJob->nSndErr = pSKDP_DoDirRemove(lpJob);
							break;
						case SKDPFC_FILEINFO:
							lpJob->nSndErr = pSKDP_DoFileInfo(lpJob);
							break;
						case SKDPFC_SETFATTR:
							lpJob->nSndErr = pSKDP_DoSetFAttr(lpJob);
							break;
						case SKDPFC_SETFDATE:
							lpJob->nSndErr = pSKDP_DoSetFDate(lpJob);
							break;
						case SKDPFC_FILERENAME:
							lpJob->nSndErr = pSKDP_DoFileRename(lpJob);
							break;
						case SKDPFC_FILEDELETE:
							lpJob->nSndErr = pSKDP_DoFileDelete(lpJob);
							break;
						case SKDPFC_FILEIO:
							lpJob->nSndErr = pSKDP_DoFileIO(lpJob);
							break;
						case SKDPFC_SFVREAD:
							lpJob->nSndErr = pSKDP_DoSfvRead(lpJob);
							break;
						case SKDPFC_CREATEDATA:
							lpJob->nSndErr = pSKDP_DoCreateData(lpJob);
							break;
						case SKDPFC_READKEY:
							lpJob->nSndErr = pSKDP_DoReadKey(lpJob);
							break;
						case SKDPFC_WRITEKEY:
							lpJob->nSndErr = pSKDP_DoWriteKey(lpJob);
							break;
						default:
							lpJob->nSndErr = SKDPERR_UNSUPPORTED;
							break;
						}
						SKDP_SendJob(lpJob, -1, -1, 0, 0, NULL, -1, FALSE);
					}
					else {
						do {
							nStart = GetTickCount();
							while (!lpJob->bRcvRdy) {
								Sleep(0);
								nDelta = GetTickCount() - nStart;
								if (nDelta >= 1000) {
									lpJob->bRcvRdy = TRUE;
									SetBit((LPVOID) &g_SKDPInfo.nJobActive, lpJob->nClntIdx - 1, 0);
									SetBit((LPVOID) &g_SKDPInfo.nJobTimeOut, lpJob->nClntIdx - 1, 0);
									lpJob->nRcvErr = SKDPERR_TIMEOUT;
								}
							} 
							nErr = lpJob->nRcvErr;
							pSndChk = lpJob->pSndChk;
							if (nErr == SKDPERR_JOBREINITIALIZED) lpJob->bTskRdy = TRUE;
							else {
								LockThread(_SKDP_LOCK);
								if (pSndChk) nErr = pSndChk(lpJob, nErr);
								else lpJob->bTskRdy = TRUE;
								if (lpJob->bTskRdy) lpJob->pSndChk = NULL;
								UnLockThread(_SKDP_LOCK);
							}
						} while (!lpJob->bTskRdy);
						lpJob->nRcvErr = nErr;
						pSKDP_Callback(SKDP_CB_JOB, nErr, lpJob, NULL);
						if (hEvent) SetEvent(hEvent);
					}
				}
				break;
			case 1:
				ResetEvent(lpJob->hEventTest);
				break;
			}
		} while (!bQuit);
	}
	__except(EXCEPTION_EXECUTE_HANDLER) {
		nRet = GetExceptionCode();
	} // end of try - except
	lpJob->bQuit = 0;
	lpJob->hThread = NULL;
#ifdef _DEBUG
	DbgStrPrint("Udp job thread(0x%x) ended.\r\n", _getptd()->nThreadID);
#endif	//	_DEBUG
	return nRet;
}
// **********************************************************************************
INT32 __stdcall SKDP_SendPacket(LPSKDPJOB lpJob, LPSKDPPACKET lpPkt, BOOL bSKDP) {
INT32	nRet, nChk, nLen;

	nLen = lpPkt->nLen;
	if (bSKDP) nLen += sizeof(SKDPHEADER);
	nChk = sendto(g_SKDPInfo.NetInf.nSkt, lpPkt->cUdp, nLen, 0, &lpPkt->Adr.sa, sizeof(SOCKETADDRESS));
	if (nChk == SOCKET_ERROR) {
		nRet = SKDPERR_SENDFAILED;
		lpPkt->nSysErr = WSAGetLastError();
	}
	else {
		nRet = lpPkt->nSysErr = 0;
	}
	if (g_SKDPInfo.nDebug & SKDP_DBGM_SND) {
		pSKDP_Callback(SKDP_CB_DBGSEND, nRet, lpJob, lpPkt);
	}
	return nRet;
}
// **********************************************************************************
INT32 __stdcall SKDP_SendJob(LPSKDPJOB lpJob, INT32 nFn, INT32 nLen, INT32 nBlk, INT32 nTOut,
								SKDPSNDCHKPROC lpChk, INT32 nRetry, BOOL bRetry) {
INT32	nSndBlk, nSize;

	if (lpChk) {
		if (!lpJob->hThread) {
			lpJob->bRcvRdy = lpJob->bTskRdy = TRUE;
			return lpJob->nRcvErr = SKDPERR_THREADENDED;
		}
		lpJob->bRcvRdy = lpJob->bTskRdy = FALSE;
		lpJob->pSndChk = lpChk;
		SetEvent(lpJob->hEventUdp);
	}
	if (nLen >= 0) lpJob->nSndLen = nLen;
	if (lpJob->nFlags & SKDPFL_TYPEMASK) {
		lpJob->nRetry = 0;
	}
	else {
		lpJob->bRcvRdy = FALSE;
		lpJob->nFlags = SKDPFL_REQUEST | SKDPFL_WAITING;
		if (bRetry) lpJob->nFlags |= SKDPFL_RETRY;
		else {
			lpJob->bTskRdy = FALSE;
			lpJob->nReqID++;
			lpJob->nRcvBlkCnt = nBlk;
			lpJob->nRcvBlkState.u64 = nBlk ? SKDP_ALLBLOCK << nBlk : 0;
			lpJob->nFunction = nFn;
			lpJob->pSndData = &lpJob->cData[0];
			lpJob->pRcvData = &lpJob->cData[lpJob->nSndLen];
			lpJob->nRcvErr = lpJob->nSndErr = lpJob->nSysErr = lpJob->nRcvLen = lpJob->nRcvEnd = 0;
			lpJob->nRetry = (nRetry < 0) ? g_SKDPInfo.nRcvRetry : nRetry;
			lpJob->nReqTOut = nTOut;
		}
	}
	nSndBlk = lpJob->nSndLen / SKDP_MAXDATASIZE;
	nSize = lpJob->nSndLen - (nSndBlk * SKDP_MAXDATASIZE);
	if (nSize || !nSndBlk) nSndBlk++;
	if (nSndBlk > 1) lpJob->nFlags |= SKDPFL_MULTIBLK;
	lpJob->nSndBlkCnt = nSndBlk;
	lpJob->nSndBlkState.u64 = ~(SKDP_ALLBLOCK << nSndBlk);
	lpJob->nSndRetry = g_SKDPInfo.nSndRetry;
	SKDP_ResendJob(lpJob, FALSE);
	return 0;
}
// **********************************************************************************
INT32 __stdcall SKDP_ResendJob(LPSKDPJOB lpJob, BOOL bResend) {
INT32		nRet, i, nSize, nOfs, nFlags, nTimeOut, nSent;
UINT64		nMask;

	nSize = lpJob->nSndLen;
	nSent = nRet = nOfs = 0;
	lpJob->nFlags &= ~SKDPFL_SENT;
	nFlags = lpJob->nFlags & (SKDPFL_TYPEMASK | SKDPFL_RETRY);
	nMask = lpJob->nSndBlkState.u64;
	for (i = 0; (i < lpJob->nSndBlkCnt) && !nRet; i++) {
		lpJob->sPkt.nLen = (nSize >= SKDP_MAXDATASIZE) ? SKDP_MAXDATASIZE : nSize;
		if (nMask & 1) {
			SKDP_FillHeader(&lpJob->sPkt.Hdr, lpJob, lpJob->nFunction, nOfs, lpJob->nSndBlkCnt, i, nFlags, lpJob->nSndErr);
			MemCpy(&lpJob->sPkt.cData, &lpJob->pSndData[nOfs], lpJob->sPkt.nLen);
			nRet = SKDP_SendPacket(lpJob, &lpJob->sPkt, TRUE);
			if (!nRet) {
				SetBit(&lpJob->nSndBlkState.u64, i, 0);
				nSent++;
			}
		}
		nSize -= lpJob->sPkt.nLen;
		nOfs += lpJob->sPkt.nLen;
		nMask >>= 1;
	}
	if (nRet) {
		nTimeOut = g_SKDPInfo.nTOut_Send;
		if (nSent) lpJob->nSndRetry = g_SKDPInfo.nSndRetry;
	}
	else {
		lpJob->nFlags |= SKDPFL_SENT;
		nTimeOut = lpJob->nFlags & SKDPFL_TYPEMASK ? g_SKDPInfo.nTOut_Req : lpJob->nReqTOut;
	}
	if (lpJob->nTimeOut = nTimeOut) {
		lpJob->nTickStart = g_SKDPInfo.nTickCounter;
		SetBit((LPVOID) &g_SKDPInfo.nJobActive, lpJob->nClntIdx - 1, 1);
	}
	return nRet;
}
