/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_sfvread.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
static INT32 WINAPI MySndChkProc(LPSKDPJOB lpJob, INT32 nError) {
union {
LPSKDPSFVREPLY		pRply;
LPSTR				pStr;
}					p;
LPSTR				pData;
LPSKDPSFVREAD		pSfvRead;
INT32				nLen;

	pSfvRead = (LPSKDPSFVREAD) lpJob->pResult;
	if (!nError && pSfvRead) {
		pData = p.pStr = lpJob->pRcvData;
		pData += sizeof(SKDPSFVREPLY);
		nLen = sizeof(SKDPSFVREPLY);
		if (p.pRply->bChanged) nLen += p.pRply->nSize;
		if (nLen == lpJob->nRcvLen) {
			pSfvRead->Hdr.nSfv = p.pRply->nSfv;
			pSfvRead->Hdr.nSize = p.pRply->nSize;
			SKDPTimeToSysTime(&pSfvRead->Hdr.FTime, &p.pRply->FTime);
			if (pSfvRead->Hdr.bChanged = p.pRply->bChanged) MemCpy(pSfvRead->cData, pData, pSfvRead->Hdr.nSize);
		}
		else nError = SKDPERR_INVALIDDATA;
	}
	lpJob->bTskRdy = TRUE;
	return nError;
}
// **********************************************************************************
INT32 SKDP_SfvRead(LPSKDPJOB lpJob, INT32 nRetry, BOOL bFirst, INT32 nMaxSize, LPSTR lpFileName, LPSKDPSFVREAD lpSfvRead) {
union {
LPSKDPSFVREQUEST	pRqst;
LPSTR				pStr;
}					p;
INT32	nRet, nLen;

	LockThread(_SKDP_LOCK);
	nRet = SKDP_JobValid(lpJob, TRUE);
	if (!nRet) {
		lpJob->pResult = lpSfvRead;
		p.pStr = lpJob->cData;
		p.pRqst->nSfv = lpSfvRead->Hdr.nSfv;
		p.pRqst->nSize = lpSfvRead->Hdr.nSize;
		p.pRqst->nMaxSize = nMaxSize;
		SysTimeToSKDPTime(&p.pRqst->FTime, &lpSfvRead->Hdr.FTime);
		p.pRqst->bFirst = bFirst;
		lpSfvRead->Hdr.bChanged = FALSE;
		nLen = sizeof(SKDPSFVREQUEST) - 1 + SKDP_CpySndStr(&p.pRqst->nChrSet, lpFileName, CHRSET_AUTO | CHRSET_WIN, 1 + SKDP_MAXPATH);
		nRet = SKDP_SendJob(lpJob, SKDPFC_SFVREAD, nLen, 0, g_SKDPInfo.nTOut_IO, MySndChkProc, nRetry, FALSE);
	}
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
