/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_sharelist.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"
//#define LOCALONLY
// **********************************************************************************
void __stdcall pSKDP_ReadSharedFolders(LPSTR lpIniBuf) {
SKDPSHAREINFO	Info;
LPSKDPSHAREINFO	pInfo;
char			cKey[64], cPath[MAX_PATH + 128];
#ifdef LOCALONLY
char			cRoot[MAX_PATH];
#endif
LPSTR			pPath;
INT32			i, j, k, nMax;

	nMax = GetIniBufInt(lpIniBuf, STR_SHARE, STR_MAXFOLDER, 0, ABSMAXSHARE, ABSMAXSHARE);
	for (i = 0; i < nMax; i++) {
		StrPrint(cKey, "%s%d", STR_FOLDER, i + 1);
		GetIniBufStr(lpIniBuf, STR_SHARE, cKey, cPath, sizeof(cPath), NULL);
		j = ChrInStr(cPath, '|', 0, MAX_SIGNED32, FALSE);
		if (j >= 0) {
			MemClr(&Info, sizeof(Info));
			Info.nID = g_SKDPInfo.pShareList->nCount;
			cPath[j] = 0;
			pPath = &cPath[j + 1];
			j = TrimCpyN(Info.cName, cPath, sizeof(Info.cName), TSM_BOTH);
			if (j && StrICmp(Info.cName, STR_DEFAULT)) {
				j = TrimStr(pPath, TSM_BOTH);
				if (j) {
					FormatFolder(pPath, TRUE);
					if (FExpand(cPath, pPath, NULL, FALSE) && (CheckFolderName(cPath) >= CPR_VALID)) {
#ifdef LOCALONLY

						if (TrueName(cPath, MAX_PATH, cPath, TRUE)) {
							GetRootDir(cRoot, cPath);
							k = GetDriveType(cRoot);
						}
						else k = 0;
						if ((k == DRIVE_FIXED) && CreateFolder(cPath, NULL)) {
#else
						if (CreateFolder(cPath, NULL)) {
#endif
							j = Sort_Find(g_SKDPInfo.pShareList, cPath, &Info, TRUE, NULL);
							if (j < 0) {
								for (k = 0; k < g_SKDPInfo.pShareList->nCount; k++) {
									pPath = Sort_Item(g_SKDPInfo.pShareList, k);
									pInfo = (LPSKDPSHAREINFO) (pPath - sizeof(SKDPSHAREINFO));
									if (StrICmp(pInfo->cName, Info.cName) == 0) {
										j = 0;
										break;
									}
								}
								if (j < 0) {
									j = Sort_Add(g_SKDPInfo.pShareList, cPath, &Info, TRUE, 0);
									pPath = Sort_Item(g_SKDPInfo.pShareList, j);
									pInfo = (LPSKDPSHAREINFO) (pPath - sizeof(SKDPSHAREINFO));
								}
							}
						}
					}
				}
			}
		}
	}
}
// **********************************************************************************
void __stdcall pSKDP_ReadShareList(LPSTR lpIniBuf, LPSTR lpSection, UINT32 nConID) {
LPSKDPSHAREINFO	pInfo;
char			cKey[64], cName[MAX_PATH + 128];
LPSTR			pPath, pRight;
INT32			i, j, k, nRights, nMax, nMask, nDirCnt;
UINT32			nConRead, nConWrite, nConExec, nFlags;
union {
UINT8			u8[SKDP_MAXFOLDER];
UINT32			u32[SKDP_MAXFOLDER >> 2];
}				nDirs;
BOOL			bDefault;

	nMax = GetIniBufInt(lpIniBuf, lpSection, STR_MAXFOLDER, 0, SKDP_MAXFOLDER, SKDP_MAXFOLDER);
	nMask = nConID ? 1 << (nConID - 1) : 0;
	nDirCnt = 0;
	MemClr(&nDirs, sizeof(nDirs));
	for (i = 0; i < nMax; i++) {
		StrPrint(cKey, "%s%d", STR_FOLDER, i + 1);
		GetIniBufStr(lpIniBuf, lpSection, cKey, cName, sizeof(cName), NULL);
		j = ChrInStrRev(cName, '|', MAX_SIGNED32, FALSE);
		if (j >= 0) {
			cName[j] = 0;
			pRight = &cName[j + 1];
			j = TrimStr(cName, TSM_BOTH);
			if (j) {
				nConRead = nConWrite = nConExec = nFlags = 0;
				j = ChrInStr(pRight, 'R', 0, MAX_SIGNED32, TRUE);
				nRights = (j >= 0) ? SKDP_SR_READ : 0;
				j = ChrInStr(pRight, 'W', 0, MAX_SIGNED32, TRUE);
				if (j >= 0) nRights |= SKDP_SR_WRITE | SKDP_SR_READ;
				j = ChrInStr(pRight, 'E', 0, MAX_SIGNED32, TRUE);
				if (j >= 0) nRights |= SKDP_SR_EXEC | SKDP_SR_READ;
				j = ChrInStr(pRight, 'D', 0, MAX_SIGNED32, TRUE);
				bDefault = j >= 0;
				if (nRights) {
					if (nMask) {
						if (nRights & SKDP_SR_READ) nConRead = nMask;
						if (nRights & SKDP_SR_WRITE) nConWrite = nMask;
						if (nRights & SKDP_SR_EXEC) nConExec = nMask;
					}
					else nFlags = nRights;
					k = - 1;
					for (j = 0; j < g_SKDPInfo.pShareList->nCount; j++) {
						pPath = Sort_Item(g_SKDPInfo.pShareList, j);
						pInfo = (LPSKDPSHAREINFO) (pPath - sizeof(SKDPSHAREINFO));
						if (StrICmp(pInfo->cName, cName) == 0) {
							pInfo->nFlags |= nFlags;
							pInfo->nConRead |= nConRead;
							pInfo->nConWrite |= nConWrite;
							pInfo->nConExec |= nConExec;
							k = j;
							break;
						}
					}
					if (k >= 0) {
						if (bDefault) {
							nDirs.u8[nDirCnt] = nDirs.u8[0];
							nDirs.u8[0] = pInfo->nID;
						}
						else nDirs.u8[nDirCnt] = pInfo->nID;
						nDirCnt++;
					}
				}
			}
		}
	}
	if (nConID) {
		g_SKDPInfo.pConInfo[nConID - 1].nDirCnt = nDirCnt;
		MemCpy(&g_SKDPInfo.pConInfo[nConID - 1].nDirs, &nDirs, sizeof(nDirs));
	}
	else {
		g_SKDPInfo.nDirCnt = nDirCnt;
		MemCpy(&g_SKDPInfo.nDirs, &nDirs, sizeof(nDirs));
	}
}
