/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_tout.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"
// **********************************************************************************
static INT32 __stdcall _pSKDP_ResendRequest(LPSKDPJOB lpJob, INT32 nFlags) {
INT32	nRet;

	SKDP_FillHeader(&lpJob->sPkt.Hdr, lpJob, lpJob->nFunction, 0, 1, 0, nFlags, 0);
	lpJob->sPkt.qwData[0] = ~lpJob->nRcvBlkState.u64;
	lpJob->nTimeOut = g_SKDPInfo.nTOut_Std;
	lpJob->nTickStart = g_SKDPInfo.nTickCounter;
	SetBit((LPVOID) &g_SKDPInfo.nJobActive, lpJob->nClntIdx - 1, 1);
	lpJob->sPkt.nLen = sizeof(lpJob->nRcvBlkState);
	nRet = SKDP_SendPacket(lpJob, &lpJob->sPkt, TRUE);
	return nRet;
}
// **********************************************************************************
void pSKDP_TimeOut() {
LPSKDPJOB	pJob;
INT32		i;
UINT32		nMask;

	nMask = 1;
	for (i = 0; i < g_SKDPInfo.nMaxJob; i++) {
		if (g_SKDPInfo.nJobTimeOut & nMask) {
			pJob = g_SKDPInfo.pJobs[i];
			SetBit((LPVOID) &g_SKDPInfo.nJobActive, i, 0);
			SetBit((LPVOID) &g_SKDPInfo.nJobTimeOut, i, 0);
			if (pJob->nFlags & SKDPFL_SENT) {
				if (pJob->nRetry) {
					pJob->nRetry--;
					if (pJob->nFlags & SKDPFL_TYPEMASK) {
						_pSKDP_ResendRequest(pJob, SKDPFL_REPLY | SKDPFL_RESEND);
					}
					else {
						if (pJob->nFlags & SKDPFL_WAITING) {
							SKDP_SendJob(pJob, -1, -1, -1, 0, NULL, -1, TRUE); 
						}
						else {
							_pSKDP_ResendRequest(pJob, SKDPFL_REQUEST | SKDPFL_RESEND);
						}
					}
				}
				else {
					if (pJob->nFlags & SKDPFL_TYPEMASK) {
						SKDP_FreeJob(pJob);
					}
					else {
						pJob->nRcvErr = SKDPERR_TIMEOUT;
						pJob->bRcvRdy = TRUE;
						if (g_SKDPInfo.nDebug & SKDP_DBGM_TOUT) {
							pSKDP_Callback(SKDP_CB_DBGTIMEOUT, SKDPERR_TIMEOUT, pJob, NULL);
						}
					}
				}
			}
			else {
				if (pJob->nSndRetry) {
					pJob->nSndRetry--;
					SKDP_ResendJob(pJob, FALSE); 
				}
				else {
					if (pJob->nFlags & SKDPFL_REPLY) {
						SKDP_FreeJob(pJob);
					}
					else {
						pJob->nRcvErr = SKDPERR_SENDFAILED;
						pJob->bRcvRdy = TRUE;
					}
					if (g_SKDPInfo.nDebug & SKDP_DBGM_TOUT) {
						pSKDP_Callback(SKDP_CB_DBGTIMEOUT, SKDPERR_SENDFAILED, pJob, NULL);
					}
				}
			}
		}
		nMask <<= 1;
	}
}
