/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_main.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
static void __stdcall pSKDP_ServerMsg(INT32 nFunc) {
INT32	i;

	LockThread(_SKDP_LOCK);
	SKDP_FillHeader(&g_SKDPInfo.pSPkt->Hdr, NULL, nFunc, 0, 1, 0, SKDPFL_BROADCAST, 0);
	g_SKDPInfo.pSPkt->Adr.nIp = g_SKDPInfo.NetInf.nLocBroadCast;
	g_SKDPInfo.pSPkt->Adr.nPort = g_SKDPInfo.NetInf.nPort;
	if (nFunc == SKDPFC_SRVRINIT) {
		g_SKDPInfo.pSPkt->cData[0] = CHRSET_WIN;
		g_SKDPInfo.pSPkt->nLen = StrCpy(&g_SKDPInfo.pSPkt->cData[1], g_SKDPInfo.UsrInf.cPCName) + 2;
	}
	else g_SKDPInfo.pSPkt->nLen = 0;
	for (i = 0; i < 3; i++) {
		SKDP_SendPacket(NULL, g_SKDPInfo.pSPkt, TRUE);
		DoEvents(NULL, 200, NULL);
	}
	UnLockThread(_SKDP_LOCK);
}
// **********************************************************************************
UINT32 __stdcall pSKDP_ThreadProc(LPVOID lpUnUsed) {
WSANETWORKEVENTS	NetEvents;
UINT32				nWait;
INT32				nResult, nRet;

#ifdef _DEBUG
	DbgStrPrint("Udp thread(0x%x) started.\r\n", _getptd()->nThreadID);
#endif	//	_DEBUG
	__try {
		nRet = 0;
		SetThreadPriority(_getptd()->hThread, THREAD_PRIORITY_HIGHEST);
		pSKDP_ServerMsg(SKDPFC_SRVRINIT);
		do {
			nWait = WaitForMultipleObjects(SKDP_MAXEVENTS, g_SKDPInfo.hEvents, FALSE, INFINITE) - WAIT_OBJECT_0;
			if (g_SKDPInfo.bActive) {
				switch (nWait) {
				case SKDP_EVENTPACKET:
					nResult = WSAEnumNetworkEvents(g_SKDPInfo.NetInf.nSkt, g_SKDPInfo.hEventPacket, &NetEvents);
					if ((nResult != SOCKET_ERROR) && (NetEvents.lNetworkEvents & FD_READ) && (NetEvents.iErrorCode[FD_READ_BIT] == 0)) {
						LockThread(_SKDP_LOCK);
						pSKDP_Receive();
						UnLockThread(_SKDP_LOCK);
					}
					break;
				case SKDP_EVENTTIMEOUT:
					ResetEvent(g_SKDPInfo.hEventTimeOut);
					LockThread(_SKDP_LOCK);
					pSKDP_TimeOut();
					UnLockThread(_SKDP_LOCK);
					break;
				case SKDP_EVENTTEST:
					ResetEvent(g_SKDPInfo.hEventTest);
					break;
				}
			}
		} while (g_SKDPInfo.bActive);
	}
	__except(EXCEPTION_EXECUTE_HANDLER) {
		nRet = GetExceptionCode();
	} // end of try - except
	WSAEventSelect(g_SKDPInfo.NetInf.nSkt, NULL, 0);
	pSKDP_ServerMsg(SKDPFC_SRVRDONE);
	g_SKDPInfo.hThread = NULL;
#ifdef _DEBUG
	DbgStrPrint("Udp thread(0x%x) ended.\r\n", _getptd()->nThreadID);
#endif	//	_DEBUG
	return nRet;
}	// end of SKDP_ThreadProc()
