/********************************************************************
 * Copyright (c) 2011-12 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_version.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
static INT32 WINAPI MySndChkProc(LPSKDPJOB lpJob, INT32 nError) {
LPSKDPVERSION	pVersion;

	if (!nError) {
		pSKDP_CvtVersion(lpJob);
		pVersion = (LPSKDPVERSION) lpJob->pRcvData;
		pSKDP_ConUpdate(lpJob, pVersion->cComputer, lpJob->sPkt.Adr.nIp);
		MemCpy(lpJob->pResult, lpJob->pRcvData, sizeof(SKDPVERSION));
	}
	lpJob->bTskRdy = TRUE;
	return nError;
}
// **********************************************************************************
INT32 SKDP_GetVersion(LPSKDPJOB lpJob, INT32 nRetry, LPSKDPVERSION lpVersion) {
INT32	nRet;

	MemClr(lpVersion, sizeof(SKDPVERSION));
	LockThread(_SKDP_LOCK);
	nRet = SKDP_JobValid(lpJob, TRUE);
	if (!nRet) {
		lpJob->pResult = lpVersion;
		pSKDP_FillVersion(lpJob, lpJob->cData);
		nRet = SKDP_SendJob(lpJob, SKDPFC_VERSION, sizeof(SKDPVERSION), 1, g_SKDPInfo.nTOut_Std, MySndChkProc, nRetry, FALSE);
	}
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
