/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - skdp_writefile.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

// **********************************************************************************
static INT32 WINAPI MySndChkProc(LPSKDPJOB lpJob, INT32 nError) {
LPSKDPFILEIO	pFile;
union {
LPSKDPFILEREPLY		pRply;
LPSTR				pStr;
}					pSrcHdr;

	if (!nError) {
		pFile = lpJob->pResult;
		pSrcHdr.pStr = lpJob->pRcvData;
		pFile->nHandle = pSrcHdr.pRply->nHandle;
		pFile->nPos = pSrcHdr.pRply->nPos;
		pFile->nSize = pSrcHdr.pRply->nSize;
	}
	lpJob->bTskRdy = TRUE;
	return nError;
}
// **********************************************************************************
INT32 __stdcall SKDP_WriteFile(LPSKDPJOB lpJob, INT32 nRetry, LPSKDPFILEIO lpFile, BOOL bRewrite, BOOL bBig, BOOL bClose) {
union {
LPSKDPFILEREQUEST	pRqst;
LPSTR				pStr;
}					pDstHdr;
union {
LPSKDPOPENMODE		pOpen;
LPSKDPIOMODE		pIO;
LPSKDPBIGIOMODE		pBigIO;
LPSTR				pStr;
}					pDst;
LPSTR				pMax;
INT32				i, nIOSize, nRet;


	LockThread(_SKDP_LOCK);
	nRet = SKDP_JobValid(lpJob, TRUE);
	if (!nRet) {
		lpJob->pResult = lpFile;
		pMax = pDstHdr.pStr = pDst.pStr = lpJob->cData;
		pMax += SKDP_MAXTRANSFERSIZE;
		pDst.pStr += sizeof(SKDPFILEREQUEST);
		pDstHdr.pRqst->nBlocks = pDstHdr.pRqst->nReserved = 0;
		pDstHdr.pRqst->nFlags = SKDP_IOF_WRITE;
		if (bBig) pDstHdr.pRqst->nFlags |= SKDP_IOF_BIGFILE;
		if (bClose) pDstHdr.pRqst->nFlags |= SKDP_IOF_CLOSE;
		if (!(pDstHdr.pRqst->nHandle = lpFile->nHandle)) {
			pDstHdr.pRqst->nFlags |= SKDP_IOF_OPEN;
			pDstHdr.pRqst->nBlocks++;
			pDst.pOpen->nMode = FOM_WRITE | FOM_SHARE;
			if (bRewrite) pDst.pOpen->nMode |= FOM_REWRITE;
			pDst.pOpen->nChrSet = CHRSET_WIN;
			pDst.pStr += SKDP_CpySndStr(pDst.pOpen->cFile, lpFile->cName, pDst.pOpen->nChrSet, SKDP_MAXPATH);
			pDst.pStr += sizeof(SKDPOPENMODE) - SKDP_MAXPATH;
		}
		nIOSize = bBig ? sizeof(SKDPBIGIOMODE) : sizeof(SKDPIOMODE);
		for (i = 0; (i < lpFile->nBlocks) && !nRet; i++) {
			if (lpFile->IO[i].nMode == FSM_TIME) {
				if ((pDst.pStr + nIOSize) <= pMax) {
					pDstHdr.pRqst->nBlocks++;
					pDst.pIO->nReserved = 0;
					pDst.pIO->nMode = FSM_TIME;
					SysTimeToSKDPTime(&pDst.pIO->st, &lpFile->IO[i].st);
					pDst.pStr += nIOSize;
				}
				else nRet = SKDPERR_INVALIDDATA;
			}
			else if ((pDst.pStr + lpFile->IO[i].nSize + nIOSize) <= pMax) {
				pDstHdr.pRqst->nBlocks++;
				pDst.pIO->nMode = lpFile->IO[i].nMode;
				pDst.pIO->nSize = lpFile->IO[i].nSize;
				if (bBig) pDst.pBigIO->nSeek = lpFile->IO[i].nPos;
				else pDst.pIO->nSeek = (INT32) lpFile->IO[i].nPos;
				pDst.pStr += nIOSize;
				MemCpy(pDst.pStr, lpFile->IO[i].pBuf, lpFile->IO[i].nSize);
				pDst.pStr += lpFile->IO[i].nSize;
			}
			else nRet = SKDPERR_INVALIDDATA;
		}
		if (!nRet) nRet = SKDP_SendJob(lpJob, SKDPFC_FILEIO, pDst.pStr - pDstHdr.pStr, 0, 
										g_SKDPInfo.nTOut_IO, MySndChkProc, nRetry, FALSE);
	}
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
