/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - scaninibuf.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "private.h"
// **********************************************************************************
void __stdcall pScanIniBuf(LPSTR lpBuf, LPSTR lpSect, LPSTR lpKey, LPINIBUFINFO lpInfo) {
LPSTR		pFirst, pLast, pCmntFirst, pCmntLast;
char		cBuf[MAX_LINESIZE];
BOOL		bOK;
INT32		nPos, nLen;

	MemClr(lpInfo, sizeof(INIBUFINFO));
	lpInfo->nSectLen = TrimCpyN(lpInfo->cSect, lpSect, MAX_SECTIONSIZE, TSM_BOTH);
	lpInfo->nKeyLen = TrimCpyN(lpInfo->cKey, lpKey, MAX_KEYSIZE, TSM_BOTH);
	bOK = FALSE;
	pCmntFirst = pCmntLast = NULL;
	if (pFirst = pLast = lpBuf) {
		while (*pLast) {
			if ((*pLast++ == '\r') && (*pLast == '\n')) {
				if (nLen = TrimCpyN(cBuf, pFirst, min(MAX_LINESIZE, pLast - pFirst), TSM_BOTH)) {
					if (cBuf[0] == '[') {
						if (cBuf[--nLen] == ']') {
							cBuf[nLen] = 0;
							if (TrimCpy(cBuf, &cBuf[1], TSM_BOTH)) {
								if (StrICmp(cBuf, lpInfo->cSect) == 0) {
									bOK = TRUE;
									lpInfo->pSect = pFirst;
									lpInfo->pSectFirst = pLast + 1;
								}
								else {
									if (bOK) lpInfo->pSectEnd = pFirst;
									bOK = FALSE;
								}
							}
						}
					}
					else if (bOK) {
						if (cBuf[0] == ';') {
							if (pFirst != (pCmntLast + 1)) pCmntFirst = pFirst;
							pCmntLast = pLast;
						}
						else {
							nPos = ChrInStr(cBuf, '=', 0, MAX_SIGNED32, FALSE);
							if (nPos >= 0) {
								cBuf[nPos++] = 0;
								if (TrimStr(cBuf, TSM_BOTH)) {
									if (StrICmp(cBuf, lpInfo->cKey) == 0) {
										lpInfo->nValLen = TrimCpyN(lpInfo->cVal, &cBuf[nPos], MAX_LINESIZE, TSM_BOTH);
										lpInfo->pKeyFirst = pFirst;
										lpInfo->pKeyLast = pLast;
										if (pFirst == (pCmntLast + 1)) {
											lpInfo->pCmntFirst = pCmntFirst;
											lpInfo->pCmntLast = pCmntLast;
										}
									}
								}
							}
						}
					}
				}
				pFirst = ++pLast;
			}
		}
	}
	if (!lpInfo->pSect || !lpInfo->pSectEnd) lpInfo->pSectEnd = pLast;
	lpInfo->pBufEnd = pLast;
	lpInfo->nTxtLen = pLast - lpBuf;
}