/********************************************************************
 * Copyright (c) 2011-13 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - serialcom.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include <sklibcom.h>

#define IOBUFFERSIZE		256
#define WINBUFFERSIZE		2048

// **********************************************************************************
static void __stdcall pDoCallBack(LPCOMINFO lpInfo) {

	if (lpInfo->hUserEvent) SetEvent(lpInfo->hUserEvent);
	else if (lpInfo->pComProc) lpInfo->pComProc(lpInfo);
}
// **********************************************************************************
static INT32 __stdcall pSetWriteError(LPCOMINFO lpInfo, INT32 nError) {

	PurgeComm(lpInfo->hDevice, PURGE_TXABORT | PURGE_TXCLEAR);
	RingBuffer_Clear(&lpInfo->rbSnd, 0);
	ResetEvent(lpInfo->hEventWrite);
	lpInfo->nWritten = 0;
	lpInfo->bWriteErr = 1;
	pDoCallBack(lpInfo);
	return nError;
}
// **********************************************************************************
static BOOL __stdcall pSetLineErr(LPCOMINFO lpInfo, LPCOMSTAT lpStat) {
COMSTAT		ComStat;
LPCOMSTAT	pComStat;
UINT32		nState;
INT32		nError;
BOOL		bRet;

	pComStat = (lpStat) ? lpStat : &ComStat;
	bRet = ClearCommError(lpInfo->hDevice, &nState, pComStat);
	if (bRet) {
		lpInfo->bBreak = (nState & CE_BREAK) ? 1 : 0;
		lpInfo->bFrame = (nState & CE_FRAME) ? 1 : 0;
		lpInfo->bOvRun = (nState & CE_OVERRUN) ? 1 : 0;
		lpInfo->bRxOver = (nState & CE_RXOVER) ? 1 : 0;
		lpInfo->bParity = (nState & CE_RXPARITY) ? 1 : 0;
		lpInfo->bLineErr = (lpInfo->nState & CSF_ERRMASK) ? 1 : 0;
		nError = 0;
	}
	else nError = GetLastError();
	return bRet;
}
// **********************************************************************************
static BOOL __stdcall pSetModemState(LPCOMINFO lpInfo) {
UINT32		nState, nPrevState;
INT32		nError;
BOOL		bRet;

	nPrevState = lpInfo->nState;
	bRet = GetCommModemStatus(lpInfo->hDevice, &nState);
	if (bRet) {
		lpInfo->bCTS = (nState & MS_CTS_ON) ? 1 : 0;
		lpInfo->bDSR = (nState & MS_DSR_ON) ? 1 : 0;
		lpInfo->bRing = (nState & MS_RING_ON) ? 1 : 0;
		lpInfo->bRLSD = (nState & MS_RLSD_ON) ? 1 : 0;
		lpInfo->bModem = (lpInfo->nState ^ nPrevState) & CSF_MODEMMASK ? 1 : 0;
		nError = 0;
	}
	else nError = GetLastError();
	return bRet;
}
// **********************************************************************************
static INT32 __stdcall SendFromBuf(LPCOMINFO lpInfo) {
BOOL		bRet;
INT32		nErr, nRet;

	lpInfo->bSending = TRUE;
	lpInfo->nWritten = RingBuffer_Read(&lpInfo->rbSnd, lpInfo->cOutBuf, COM_OUTSIZE, 0);
	nRet = 0;
	if (lpInfo->nWritten) {
		MemClr(&lpInfo->olWrite, sizeof(OVERLAPPED));
		lpInfo->olWrite.hEvent = lpInfo->hEventWrite;
		bRet = WriteFile(lpInfo->hDevice, lpInfo->cOutBuf, lpInfo->nWritten, NULL, &lpInfo->olWrite);
		if (!bRet) {
			nErr = GetLastError();
			if (nErr != ERROR_IO_PENDING) nRet = pSetWriteError(lpInfo, nErr);
		}
	}
	if (!lpInfo->nWritten) lpInfo->bSending = FALSE;
	return nRet;
} // end of SendFromBuf()
// **********************************************************************************
static UINT32 __stdcall ComThreadProc(LPCOMINFO lpInfo) {
COMSTAT		ComStat;
OVERLAPPED	olState, olRead;
UINT32		nEvtMask, nWait, nPrevState;
INT32		nCount, nTotalRead, nRead, nReady, nWritten, nError, nRet;
BOOL		bRet, bEvent;
UINT8		cBuffer[IOBUFFERSIZE];

#ifdef _DEBUG
	DbgStrPrint("Com thread(0x%x) started.\r\n", _getptd()->nThreadID);
#endif	//	_DEBUG
	__try {
		nRet = 0;
		SetThreadPriority(_getptd()->hThread, THREAD_PRIORITY_ABOVE_NORMAL);
		if (SetCommMask(lpInfo->hDevice, EV_RXCHAR | EV_BREAK | EV_CTS | EV_DSR | EV_ERR | EV_RING | EV_RLSD)) {
			do {
				nEvtMask = 0;
				MemClr(&olState, sizeof(OVERLAPPED));
				olState.hEvent = lpInfo->hEventState;
				WaitCommEvent(lpInfo->hDevice, &nEvtMask, &olState);
				nWait = WaitForMultipleObjects(COM_MAXEVENTS, lpInfo->hEvents, FALSE, INFINITE) - WAIT_OBJECT_0;
				if ((nWait >= COM_EVENTSTATE) && (nWait < COM_MAXEVENTS)) ResetEvent(lpInfo->hEvents[nWait]);
				if (lpInfo->bConnected) {
					LockThread(_COM_LOCK);
					switch (nWait) {
					case COM_EVENTSTATE:
						nPrevState = lpInfo->nState;
						bEvent = FALSE;
						nError = 0;
						if (nEvtMask & (EV_CTS | EV_DSR | EV_RING | EV_RLSD)) {
							pSetModemState(lpInfo);
							bEvent = TRUE;
						}
						if (nEvtMask & (EV_BREAK | EV_ERR | EV_RXCHAR)) {
							nTotalRead = 0;
							do {
								bRet = pSetLineErr(lpInfo, &ComStat);
								nCount = bRet ? ComStat.cbInQue : 0;
								while (nCount && bRet) {
									nRead = (nCount > IOBUFFERSIZE) ? IOBUFFERSIZE : nCount;
									MemClr(&olRead, sizeof(OVERLAPPED));
									olRead.hEvent = lpInfo->hEventRead;
									bRet = ReadFile(lpInfo->hDevice, cBuffer, nRead, &nReady, &olRead);
									if (bRet) {
										if (nRead == nReady) {
											nCount -= nRead;
											if (!lpInfo->bLineErr) {
												RingBuffer_Write(&lpInfo->rbRcv, cBuffer, nRead, 0);
												nTotalRead += nRead;
												lpInfo->bReadErr = 0;
											}
										}
										else nError = ERROR_READ_FAULT;
									}
									else nError = GetLastError();
									if (nError) {
										PurgeComm(lpInfo->hDevice, PURGE_RXABORT | PURGE_RXCLEAR);
										bRet = FALSE;
										nTotalRead = nCount = nRead = 0;
										RingBuffer_Clear(&lpInfo->rbRcv, 0);
										lpInfo->nError = nError;
										lpInfo->bReadErr = 1;
									}
									ResetEvent(lpInfo->hEventRead);
								}
							} while (nCount && bRet);
							if ((lpInfo->nState ^ nPrevState) & CSF_ERRMASK) bEvent = TRUE;
							if (nTotalRead) {
								lpInfo->bReadRdy = 1;
								bEvent = TRUE;
							}
						}
						if (bEvent) pDoCallBack(lpInfo);
						break;
					case COM_EVENTWRITE:
						nWritten = 0;
						bRet = GetOverlappedResult(lpInfo->hDevice, &lpInfo->olWrite, &nWritten, FALSE);
						if (bRet) {
							nError = (nWritten == lpInfo->nWritten) ? 0 : ERROR_WRITE_FAULT;
						}
						else nError = GetLastError();
						if (nError) pSetWriteError(lpInfo, nError);
						else {
							nError = SendFromBuf(lpInfo);
							if (!lpInfo->bSending) {
								if (!nError) {
									lpInfo->bWriteRdy = 1;
									pDoCallBack(lpInfo);
								}
							}
						}
						break;
					case COM_EVENTREAD:
						break;
					case COM_EVENTTEST:
						break;
					}
					UnLockThread(_COM_LOCK);
				}
			} while (lpInfo->bConnected);
		}
	}
	__except(EXCEPTION_EXECUTE_HANDLER) {
		nRet = GetExceptionCode();
	} // end of try - except
	lpInfo->hThread = NULL;
#ifdef _DEBUG
	DbgStrPrint("Com thread(0x%x) ended.\r\n", _getptd()->nThreadID);
#endif	//	_DEBUG
	return nRet;
}	// end of ComThreadProc()
// **********************************************************************************
LPCOMINFO __stdcall Serial_Init(HWND hOwner, HANDLE hEvent, COMEVENTPROC lpComProc, LPCOMPARS lpComPars, INT32 nInpSize, INT32 nOutSize) {
LPCOMINFO		pInfo;
COMMTIMEOUTS	CommTimeOuts ;
DCB				dcb;
char			szPort[16];
HCURSOR			hOldCursor;
UINT32			i;
BOOL			bOK;

	pInfo = GetMem(GMM_CLEAR, sizeof(COMINFO));
	if (!pInfo) return NULL;
	pInfo->hDevice = INVALID_HANDLE_VALUE;
	bOK = RingBuffer_Init(&pInfo->rbSnd, nInpSize, RBU_BYTE1);
	if (bOK) bOK = RingBuffer_Init(&pInfo->rbRcv, nOutSize, RBU_BYTE1);
	if (!bOK) {
		pInfo->nError = ERROR_OUTOFMEMORY;
		return pInfo;
	}
	hOldCursor = SetCursorFromResource(hOwner, NULL, IDC_WAIT);
// load the COM prefix string and append port number
	MemCpy(&pInfo->Params, lpComPars, sizeof(COMPARS));
	StrPrint(szPort, "%s%d", STR_COM, pInfo->Params.nPort);
// open COMM device
	pInfo->hDevice = CreateFile(szPort, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	if (pInfo->hDevice == INVALID_HANDLE_VALUE) bOK = FALSE;
	else {
		if (hEvent) pInfo->hUserEvent = hEvent;
		else if (lpComProc) pInfo->pComProc = lpComProc;
		else pInfo->hOwner = hOwner;
		bOK = SetCommMask(pInfo->hDevice, 0);
// setup device buffers
		if (bOK) bOK = SetupComm(pInfo->hDevice, WINBUFFERSIZE, WINBUFFERSIZE);
// purge any information in the buffer
		if (bOK) bOK = PurgeComm(pInfo->hDevice, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
		MemClr(&CommTimeOuts, sizeof(CommTimeOuts));
		CommTimeOuts.ReadIntervalTimeout = MAX_UNSIGNED32;
		if (bOK) bOK = SetCommTimeouts(pInfo->hDevice, &CommTimeOuts);			// no windows timeout
		MemClr(&dcb, sizeof(DCB));
		dcb.DCBlength = sizeof(DCB);
		if (bOK) bOK = GetCommState(pInfo->hDevice, &dcb);
		if (bOK) {
			dcb.BaudRate = lpComPars->nBaudRate;
			dcb.ByteSize = lpComPars->nDataBits;
			dcb.Parity = lpComPars->nParity;
			dcb.StopBits = lpComPars->nStopBits;
//			dcb.fAbortOnError = FALSE;
			dcb.XonChar = CHR_XON ;
			dcb.XoffChar = CHR_XOFF ;
			dcb.fBinary = dcb.fParity = TRUE;
			dcb.XonLim = dcb.XoffLim = WINBUFFERSIZE >> 1;
			dcb.fTXContinueOnXoff = dcb.fOutX = dcb.fInX = lpComPars->XOnXOff;
			dcb.fOutxCtsFlow = lpComPars->CtsFlow;
			dcb.fOutxDsrFlow = lpComPars->DsrFlow;
			dcb.fDsrSensitivity = lpComPars->DsrSens;
			dcb.fDtrControl = lpComPars->DtrCtrl;
			dcb.fRtsControl = lpComPars->RtsCtrl;
			bOK = SetCommState(pInfo->hDevice, &dcb);
		}
		if (bOK) bOK = pSetLineErr(pInfo, NULL);
		if (bOK) bOK = pSetModemState(pInfo);
		for (i = 0; (i < COM_MAXEVENTS) && bOK; i++) {
			pInfo->hEvents[i] = CreateEvent(0, TRUE, 0, 0);
			bOK = pInfo->hEvents[i] != NULL;
		}
		if (bOK) {
			pInfo->bConnected = TRUE;
			if (!(pInfo->hThread = SimpleThread(ComThreadProc, pInfo))) bOK = FALSE;
		}
		else pInfo->nError = GetLastError();
	}
	if (!bOK) pInfo->nError = GetLastError();
	SetCursorFromHandle(hOwner, hOldCursor);								// restore cursor
	return pInfo;
} // end of Serial_Init()
// **********************************************************************************
void __stdcall Serial_Done(LPCOMINFO *lpInfo, BOOL bSendBreak) {
LPCOMINFO	pCom;
INT32		i, brk;

	if (!lpInfo || !(pCom = *lpInfo)) return;
	*lpInfo = NULL;
	if (pCom->hDevice != INVALID_HANDLE_VALUE) {
		pCom->bConnected = FALSE;
		SetCommMask(pCom->hDevice, 0);
		EscapeCommFunction(pCom->hDevice, CLRDTR);
		EscapeCommFunction(pCom->hDevice, CLRRTS);
		PurgeComm(pCom->hDevice, PURGE_TXABORT | PURGE_RXABORT | PURGE_TXCLEAR | PURGE_RXCLEAR);
		brk = bSendBreak ? SETBREAK : CLRBREAK;
		EscapeCommFunction(pCom->hDevice, brk);
		if (pCom->hThread) {
			SetEvent(pCom->hEventWrite);
			WaitForZero(&pCom->hThread, 1000);
		}
		if (pCom->hThread) {
			TerminateThread(pCom->hThread, -1);
		}
		for (i = 0; i < COM_MAXEVENTS; i++) {
			if (pCom->hEvents[i]) {
				ResetEvent(pCom->hEvents[i]);
				CloseHandle(pCom->hEvents[i]);
			}
		}
		CloseHandle(pCom->hDevice);
	}
	RingBuffer_Done(&pCom->rbSnd);
	RingBuffer_Done(&pCom->rbRcv);
	FreeMem(pCom);
} // end of Serial_Done()
// **********************************************************************************
INT32 __stdcall Serial_Read(LPCOMINFO lpInfo, LPVOID lpBuffer, INT32 nSize) {

	if (!lpInfo || !lpInfo->bConnected) return 0;
	nSize = RingBuffer_Read(&lpInfo->rbRcv, lpBuffer, nSize, _COM_LOCK);
	return nSize;
} // end of Serial_Read()
// **********************************************************************************
INT32 __stdcall Serial_Write(LPCOMINFO lpInfo, LPVOID lpBuffer, INT32 nSize) {

	if (!lpInfo || !lpInfo->bConnected) return 0;
	LockThread(_COM_LOCK);
	nSize = RingBuffer_Write(&lpInfo->rbSnd, lpBuffer, nSize, 0);
	if (!lpInfo->bSending) SendFromBuf(lpInfo);
	UnLockThread(_COM_LOCK);
	return nSize;
} // end of Serial_Write()
