/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - setinibufstr.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include "private.h"
// **********************************************************************************
INT32 __stdcall SetIniBufStr(LPSTR *lpIniBuf, LPSTR lpSect, LPSTR lpKey, LPSTR lpValue) {
INIBUFINFO	Info;
INT32		nLen;

	pScanIniBuf(*lpIniBuf, lpSect, lpKey, &Info);
	if (Info.nKeyLen) {
		nLen = Info.nKeyLen + 3;
		if (Info.nValLen = TrimCpyN(&Info.cVal[nLen], lpValue, MAX_LINESIZE - nLen, TSM_BOTH)) {
			nLen = StrXCpy(Info.cVal, Info.cKey, " =");
			Info.cVal[nLen] = ' ';
			Info.nValLen += nLen + 1;
		}
	}
	else Info.nValLen = 0;
	if (Info.nSectLen) {
		if (Info.nKeyLen) {
			if (Info.pDst = Info.pKeyFirst) {
				Info.nDelLen = Info.pKeyLast - Info.pKeyFirst + 1;
				if (!Info.nValLen && Info.pCmntFirst) {
					Info.pDst = Info.pCmntFirst;
					Info.nDelLen += Info.pCmntLast - Info.pCmntFirst + 1;
				}
			}
			else Info.nDelLen = 0;
			if (!Info.pDst) Info.pDst = Info.pSectEnd;
			pUpdateIniBuf(lpIniBuf, &Info);
		}
		else if (Info.pSect) {
			MemCpy(Info.pSect, Info.pSectEnd, Info.pBufEnd - Info.pSectEnd + 1);
			Info.nTxtLen -= Info.pSectEnd - Info.pSect;
		}
	}
	return Info.nTxtLen;
}