/********************************************************************
 * Copyright (c) 2011-15 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - showpopupmenu.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
INT32	g_nPopupWidth		= 0;
INT32	g_nPopupHeight		= 0;
INT32	g_nPopupLeft		= 0;
INT32	g_nPopupTop			= 0;
BOOL	g_bPopupChecked		= FALSE;
// **********************************************************************************
void __stdcall ShowPopupMenu(HWND hWndOwner, INT32 x, INT32 y, LPTPMPARAMS lpTPM, INT32 nCount, INT32 nStrBase, UINT32 nMenuID[]) {
char		cBuf[256];
HMENU		hMenu;
RECT		rCalc;
INT32		i, nID, nFlags, nLen, nChkX, nChkY, nCnt;

	if (!nCount) return;
	g_nPopupWidth = g_nPopupHeight = 0;
	hMenu = CreatePopupMenu();
	g_bPopupChecked = FALSE;
	nCnt = 0;
	for (i = 0; i < nCount; i++) {
		if (nMenuID[i]) {
			nCnt++;
			SplitInt32(nMenuID[i], &nID, &nFlags);
			if (nID) {
				nLen = LoadString(g_hResource, nStrBase + nID, cBuf, sizeof(cBuf)) ;
			}
			else {
				nLen = cBuf[0] = 0;
			}
			if (nFlags & MF_OWNERDRAW) {
				if (nFlags & MF_SEPARATOR) {
					nFlags &= ~MF_SEPARATOR;
					nFlags |= MF_DISABLED;
				}
				AppendMenu(hMenu, nFlags, nID, RESSTR(nStrBase + nID));
				if (nLen) {
					MeasureText(NULL, hWndOwner, NULL, cBuf, &rCalc, FALSE);
					if (rCalc.right > g_nPopupWidth) g_nPopupWidth = rCalc.right;
					if (rCalc.bottom > g_nPopupHeight) g_nPopupHeight = rCalc.bottom;
				}
			}
			else {
				AppendMenu(hMenu, nFlags, nID, cBuf);
			}
			if (nFlags & MF_CHECKED) g_bPopupChecked = TRUE;
		}
	}
    nChkX = GetSystemMetrics(SM_CXMENUCHECK);
    nChkY = GetSystemMetrics(SM_CYMENUCHECK);
	g_nPopupHeight += 2;
	g_nPopupTop = 1;
	if (nChkY > g_nPopupHeight) {
		g_nPopupTop += (nChkY - g_nPopupHeight) >> 1;
		g_nPopupHeight = nChkY;
	}
	g_nPopupLeft = (nChkX + 1) >> 1;
	if (g_bPopupChecked) {
		g_nPopupWidth += g_nPopupLeft;
		g_nPopupLeft = nChkX;
	}
	if (nCnt) TrackPopupMenuEx(hMenu, TPM_LEFTALIGN | TPM_LEFTBUTTON | TPM_VERTICAL, x, y, hWndOwner, lpTPM);
	DestroyMenu(hMenu);
}
// **********************************************************************************
void __stdcall PopupMenu_Measure(HWND hDlg, UINT32 lParam) {
LPMEASUREITEMSTRUCT		pMis;

	pMis = (LPMEASUREITEMSTRUCT) lParam;
    pMis->itemWidth = g_nPopupWidth; 
    pMis->itemHeight = pMis->itemData ? g_nPopupHeight : 5; 
}
 // **********************************************************************************
void __stdcall PopupMenu_Draw(HWND hDlg, UINT32 lParam) {
LPDRAWITEMSTRUCT	pDis;
char				cBuf[256];
RECT				rTxt, rChk;
COLORREF			crText, crBkGr, crPrevText, crPrevBkGr;
BOOL				bText, bBkGr;
INT32				nLen, nChkX;

	pDis = (LPDRAWITEMSTRUCT) lParam;
	MemCpy(&rTxt, &pDis->rcItem, sizeof(RECT));
	if (pDis->itemData) {
		bText = bBkGr = FALSE;
		crText = GetSysColor(COLOR_MENUTEXT);
		crBkGr = GetSysColor(COLOR_MENU);
		if (pDis->itemState & (ODS_GRAYED | ODS_DISABLED)) {
			crText = GetSysColor(COLOR_GRAYTEXT);
			bText = TRUE;
		}
		else if (pDis->itemState & ODS_SELECTED) {
			crText = GetSysColor(COLOR_HIGHLIGHTTEXT);
			crBkGr = GetSysColor(COLOR_HIGHLIGHT);
			bText = bBkGr = TRUE;
		}
		if (bText) crPrevText = SetTextColor(pDis->hDC, crText);
		if (bBkGr) crPrevBkGr = SetBkColor(pDis->hDC, crBkGr);
		if (pDis->itemState & ODS_CHECKED) {
			nChkX = GetSystemMetrics(SM_CXMENUCHECK);
			MemCpy(&rChk, &pDis->rcItem, sizeof(RECT));
			rTxt.left += nChkX;
			MemCpy(&rChk, &pDis->rcItem, sizeof(RECT));
			rChk.right = rChk.left + nChkX;
			DrawColoredFrameControl(pDis->hDC, rChk.left, rChk.top, nChkX, rChk.bottom - rChk.top, crText, crBkGr, DFC_MENU, DFCS_MENUCHECK);
		}
		else {
			nChkX = 0;
		}
		nLen = LoadString(g_hResource, pDis->itemData, cBuf, sizeof(cBuf)) ;
		ExtTextOut(pDis->hDC, rTxt.left + g_nPopupLeft - nChkX, rTxt.top + g_nPopupTop, ETO_OPAQUE, &rTxt, cBuf, nLen, NULL); 
		if (bText) SetTextColor(pDis->hDC, crPrevText);
		if (bBkGr) SetBkColor(pDis->hDC, crPrevBkGr);
	}
	else {
		rTxt.top += 2;
		rTxt.bottom = rTxt.top + 1;
		DrawEdge(pDis->hDC, &rTxt, EDGE_ETCHED, BF_TOP);
	}
}
// **********************************************************************************
void __stdcall DrawColoredFrameControl(HDC hInDC, INT32 nLeft, INT32 nTop, INT32 nWidth, INT32 nHeight, COLORREF crFG, COLORREF crBG, INT32 nType, INT32 nState) {
HDC			hdcMem;
HBITMAP		hbmMono, hbmPrev;
RECT		rc;
COLORREF	clrTextPrev, clrBkPrev;

	hdcMem = CreateCompatibleDC(hInDC);
	hbmMono = CreateBitmap(nWidth, nHeight, 1, 1, NULL);
	SetRect(&rc, 0, 0, nWidth, nHeight);
	hbmPrev = SelectObject(hdcMem, hbmMono);
    DrawFrameControl(hdcMem, &rc, nType, nState);
	clrTextPrev = SetTextColor(hInDC, crFG);
	clrBkPrev = SetBkColor(hInDC, crBG);
    BitBlt(hInDC, nLeft, nTop, nWidth, nHeight, hdcMem, 0, 0, SRCCOPY);
    SetBkColor(hInDC, clrBkPrev);
    SetTextColor(hInDC, clrTextPrev);
    SelectObject(hdcMem, hbmPrev);
	DeleteObject(hbmMono);
	DeleteDC(hdcMem);
 }
