/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - shutdown.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
BOOL __stdcall ShutdownWindows(BOOL bReboot, BOOL bForce) {
TOKEN_PRIVILEGES	tkp;
HANDLE				hToken;
UINT32				nFlags;
BOOL				bRet;

	nFlags = bReboot ? EWX_REBOOT : EWX_POWEROFF;
	if (bForce) nFlags |= EWX_FORCE;
	if ((g_sWinVersion.Major == 4) && (g_sWinVersion.Build & 0x8000)) {
		bRet = ExitWindowsEx(nFlags, SHTDN_REASON_MAJOR_APPLICATION | SHTDN_REASON_MINOR_MAINTENANCE | SHTDN_REASON_FLAG_PLANNED);
	}
	else {
// Get a token for this process. 
 		if (!OpenProcessToken(GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &hToken)) return FALSE;
// Get the LUID for the shutdown privilege.
		LookupPrivilegeValue(NULL, SE_SHUTDOWN_NAME, &tkp.Privileges[0].Luid);
		tkp.PrivilegeCount = 1;  // one privilege to set
		tkp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;
// Get the shutdown privilege for this process.
		AdjustTokenPrivileges(hToken, FALSE, &tkp, 0, (PTOKEN_PRIVILEGES)NULL, 0);
		if (GetLastError() == ERROR_SUCCESS) {
// Shut down the system and force all applications to close.
			bRet = ExitWindowsEx(nFlags, SHTDN_REASON_MAJOR_APPLICATION | SHTDN_REASON_MINOR_MAINTENANCE | SHTDN_REASON_FLAG_PLANNED);
		}
		else bRet = FALSE;
		CloseHandle(hToken);
	}
	return bRet;
}
