/********************************************************************
 * Copyright (c) 2011-21 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - socket.c												*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"
#include <ws2ipdef.h>

#pragma comment(lib, "ws2_32.lib")

// **********************************************************************************
INT32 __stdcall OpenSocket(LPSTR lpName, UINT32 nIP, INT32 nPort, INT32 nType, INT32 nProtocol, BOOL bBind, BOOL bBC, INT32 nRTOut, INT32 nSTOut, LPNETINFO lpNetInf, LPSOCKETADDRESS lpSA, LPINT32 lpSysErr) {
#define MAX_NAMESIZE	256
WSADATA				WsaDat;
SOCKETADDRESS		saLocal;
struct hostent		*hs;
INTERFACE_INFO		InterfaceList[20];
LPSOCKETADDRESS		pAddress;
char				cComp[MAX_NAMESIZE];
INT32				i, n, nInterfaces, nOption, nResult, nError, nSysErr;

	nError = nSysErr = 0;
	if (lpNetInf) {
		MemClr(lpNetInf, sizeof(NETINFO));
		nResult = WSAStartup(MAKEWORD(2, 2), &WsaDat);
		if (nResult) {
			nError = SKDPERR_WINSOCK_INIT;
			nSysErr = WSAGetLastError();
		}
		else {
			lpNetInf->bWSA = 1;
			lpNetInf->nSkt = socket(AF_INET, nType, nProtocol);
			if (lpNetInf->nSkt == INVALID_SOCKET) {
				nError = SKDPERR_SOCKET_CREATION;
				nSysErr = WSAGetLastError();
			}
			else {
				if (!nIP) {
					if (!lpName) {
						n = MAX_NAMESIZE;
						GetComputerName(cComp, &n);
						lpName = cComp;
					}
					hs = gethostbyname(lpName);
					if (hs->h_length != sizeof(UINT32)) nError = SKDPERR_IP_VERSION;
					else MemCpy(&nIP, hs->h_addr, sizeof(UINT32));
				}
				if (!nError) {
					lpNetInf->nIp = nIP;
					nResult = WSAIoctl(lpNetInf->nSkt, SIO_GET_INTERFACE_LIST, 0, 0, &InterfaceList, sizeof(InterfaceList), &nInterfaces, 0, 0);
					if (nResult == SOCKET_ERROR) {
						nError = SKDPERR_INTERFACE_LIST;
						nSysErr = WSAGetLastError();
					}
					else {
						nInterfaces = nInterfaces / sizeof(INTERFACE_INFO);
						for (i = 0; i < nInterfaces; ++i) {
							pAddress = (LPSOCKETADDRESS) &InterfaceList[i].iiAddress;
							if (pAddress->nIp == nIP) {
								pAddress = (LPSOCKETADDRESS) &InterfaceList[i].iiBroadcastAddress;
								lpNetInf->nBroadCast = pAddress->nIp;
								pAddress = (LPSOCKETADDRESS) &InterfaceList[i].iiNetmask;
								lpNetInf->nNetMask = pAddress->nIp;
								break;
							}
						}
						if (lpNetInf->nNetMask == 0) nError = SKDPERR_NET_DETECTION;
						else lpNetInf->nLocBroadCast = (lpNetInf->nIp & lpNetInf->nNetMask) | ~lpNetInf->nNetMask;
					}
				}
			}
		}
	}
	else {
		nError = SKDPERR_WINSOCK_INIT;
	}
	if (!nError) {
		if (!lpSA) lpSA = &saLocal;
		MemClr(lpSA, sizeof(SOCKETADDRESS));
		lpSA->nFamily = AF_INET;
		lpSA->nPort = lpNetInf->nPort = ByteSwap16(nPort);
		lpSA->nIp = nIP;
		nResult = (bBind) ? bind(lpNetInf->nSkt, &lpSA->sa, sizeof(SOCKETADDRESS)) : 0;
		if (nResult == SOCKET_ERROR) {
			nError = SKDPERR_SOCKET_BIND;
			nSysErr = WSAGetLastError();
		}
		else {
			nOption = 1;
			if (bBC) {
				nResult = setsockopt(lpNetInf->nSkt, SOL_SOCKET, SO_BROADCAST, (LPSTR) &nOption, sizeof(nOption));
			}
			if (nResult != SOCKET_ERROR) {
				if (nRTOut) {
					nOption = nRTOut;		// receive timeout
					nResult = setsockopt(lpNetInf->nSkt, SOL_SOCKET, SO_RCVTIMEO, (LPSTR) &nOption, sizeof(nOption));
				}
				if ((nResult != SOCKET_ERROR) && nSTOut) {
					nOption = nSTOut;		// send timeout
					nResult = setsockopt(lpNetInf->nSkt, SOL_SOCKET, SO_SNDTIMEO, (LPSTR) &nOption, sizeof(nOption));
				}
			}
			if (nResult == SOCKET_ERROR) {
				nError = SKDPERR_SOCKET_OPTION;
				nSysErr = WSAGetLastError();
			}
		}
	}
	if (lpSysErr) *lpSysErr = nSysErr;
	return nError;
}
// **********************************************************************************
void __stdcall CloseSocket(UINT32 nSkt, BOOL bWSA) {

	if (bWSA) {
		if (nSkt) {
			shutdown(nSkt, SD_BOTH);
			closesocket(nSkt);
		}
		WSACleanup();
	}
}
