/********************************************************************
 * Copyright (c) 2011-14 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - strprint.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
//*********************************************************************
// state definitions
enum STATE {
	ST_NORMAL,			// normal state; outputting literal chars
	ST_FLAG,			// just read flag character
	ST_WIDTH,			// just read width specifier
	ST_DOT,				// just read '.'
	ST_PRECIS,			// just read precision specifier
	ST_SIZE,			// just read size specifier
	ST_TYPE				// just read type specifier
};
//*********************************************************************
INT32 __stdcall _StrPrint(LPSTR lpBuf, LPSTR lpFormat, va_list ArgPtr) {
#define MAXCONDITION	4
#define ABSMAXMILLISEC	3600000000u
static const UINT8 m_DateTable[3][3]	= {	{0, 1, 2},				//	DF_YMD
											{1, 2, 0},				//	DF_MDY
											{2, 1, 0}				//	DF_DMY
};
SYSTEMTIME		st;
LPSYSTEMTIME	pST;
LPUINT16		pWord;
LPTIDDATA		ptd;
char			ch, cSep;
LPSTR			pOut, pStrt[MAXCONDITION];
INT32			nFlags, nWidth, nPrecision, nState, nLen, i, nMask, nCondCnt;
UINT32			nDays, nSec;
ANYVALUE		Value;
BOOL			bOK, bRead, bInt64;

	if (!lpBuf) return 0;
	pOut = lpBuf;
	*pOut = '\0';
	if (!lpFormat) return 0;
	ptd = _getptd();
	nState = ST_NORMAL;
    ch = *lpFormat++;
	nCondCnt = 0;
	while (ch) {
		bOK = bRead = TRUE;
		switch (nState) {
		case ST_NORMAL:
			if (ch == '%') {
				nFlags = 0;
				nWidth = nPrecision = -1;
				bInt64 = FALSE;
				nState = ST_FLAG;
				ch = *lpFormat++;
			}
			else {
				*pOut++ = ch;
				break;
			}
		case ST_FLAG:
			switch (ch) {
			case '%':
				*pOut++ = ch;
				nState = ST_NORMAL;
				break;
			case '+':
				nFlags |= NF_PLUSSIGN;				// '+' => force sign indicator
				break;
			case ' ':
				nFlags |= NF_SPCSIGN;				// ' ' => force sign or space
				break;
			case '#':
				nFlags |= NF_SEP;					// '#' => alternate form unsupported
				break;
			case '0':
				nFlags |= NF_ZFILL;					// '0' => pad with leading zeros
				nState = ST_WIDTH;
				break;
			default:
				nState = ST_WIDTH;
				bOK = FALSE;
			}
			if (bOK) break;
			bOK = TRUE;
		case ST_WIDTH:
			if (ch == '*') {
				nWidth = va_arg(ArgPtr, INT32);
				nState = ST_DOT;
			}
			else if ((ch >= '0') && (ch <= '9')) {
				if (nWidth < 0) nWidth = 0;
				nWidth = nWidth * 10 + (ch - '0');
            }
			else {
				nState = ST_DOT;
				bOK = FALSE;
			}
			if (bOK) break;
			bOK = TRUE;
		case ST_DOT:
			if (ch == '.') {
				nState = ST_PRECIS;
				nPrecision = 0;
			}
			else {
				nState = ST_SIZE;
				bRead = FALSE;
			}
			break;
		case ST_PRECIS:
			if (ch == '*') {
				nPrecision = va_arg(ArgPtr, INT32);
				nState = ST_SIZE;
			}
			else if ((ch >= '0') && (ch <= '9')) {
				nPrecision = nPrecision * 10 + (ch - '0');
            }
			else {
				nState = ST_SIZE;
				bOK = FALSE;
			}
			if (bOK) break;
			bOK = TRUE;
		case ST_SIZE:
			switch (ch) {
			case 'I':
				if ((*lpFormat == '6') && (*(lpFormat + 1) == '4')) {
					lpFormat += 2;
					bInt64 = TRUE;
				}
				else if ((*lpFormat == '3') && (*(lpFormat + 1) == '2')) lpFormat += 2;
				break;
			case 'l':
				if (*lpFormat == 'l') {
					lpFormat++;
					bInt64 = TRUE;
				}
				break;
			case 'h':
				break;
			default:
				bOK = FALSE;
			}
			nState = ST_TYPE;
			if (bOK) break;
			bOK = TRUE;
		case ST_TYPE:
			switch (ch) {
			case '[':
				if (nCondCnt < MAXCONDITION) pStrt[nCondCnt] = pOut;
				nCondCnt++;
				break;
			case ']':
				Value.b = va_arg(ArgPtr, BOOL);
				if (nCondCnt) {
					nCondCnt--;
					if (!Value.b && (nCondCnt < MAXCONDITION)) pOut = pStrt[nCondCnt];
				}
				break;
			case 'c':
				if (nWidth < 0) nWidth = 1;
				Value.i32 = va_arg(ArgPtr, INT32);
				StrFill(pOut, Value.c, nWidth);
				pOut += nWidth;
				break;
			case 's':
				if (nWidth < 0) nWidth = MAX_SIGNED16;
				else nWidth++;
				Value.p.pStr = va_arg(ArgPtr, LPSTR);
				nLen = StrFromRes(pOut, Value.p.pStr, nWidth);
				pOut += nLen;
				break;
			case 'D':
			case 'T':
			case 't':
				nMask = 7;
				if (nWidth < 0) nWidth = 0;
				if (nPrecision <= 0) nPrecision = 0;
				if (nPrecision > 3) nPrecision = 3;
				if (ch == 't') {
					if (bInt64) {
						Value.u64 = va_arg(ArgPtr, UINT64);
						if (Value.u32hi) Value.u32lo = 0xFFFFFFFF;
					}
					else Value.u32 = va_arg(ArgPtr, UINT32);
					if (Value.u32 < 100000) {
						nLen = IntStr(pOut, Value.u32 / IntPow(10, 3 - nPrecision), NF_SINGLE, nPrecision, nWidth);
						pOut += nLen;
						break;
					}
					else {
						if (Value.u32 >= ABSMAXMILLISEC) {
							*pOut++ = '>';
							Value.u32 = ABSMAXMILLISEC - 1;
						}
						nSec = Value.u32 / 1000;
						nDays = nSec / SECONDSOFDAY;
						nSec %= SECONDSOFDAY;
						SecToTime(nSec, &st);
						st.wHour += nDays * 24;
						st.wMilliseconds = Value.u32 % 1000;
						if (Value.u32 < 3600000) nMask = 6;
						pST = &st;
					}
					ch = 'T';
				}
				else pST = va_arg(ArgPtr, LPSYSTEMTIME);
				if (pST) {
					pWord = &pST->wHour;
					for (i = 0; i < 3; i++) {
						if (nMask & 1) {
							nLen = 2;
							if (ch == 'D') {
								cSep = '.';
								switch (m_DateTable[ptd->LocInfo.nDateFormat][i]) {
								case 0:
									pWord = &pST->wYear;
									nLen = 4;
									break;
								case 1:
									pWord = &pST->wMonth;
									break;
								case 2:
									pWord = &pST->wDay;
								}
							}
							else cSep = ':';
							nLen = IntStr(pOut, *pWord, NF_ZFILL, nLen, 0);
							pOut += nLen;
							if (i < 2) *pOut++ = cSep;
						}
						pWord++;
						nMask >>= 1;
					}
					if ((ch == 'T') && nPrecision) {
						i = pST->wMilliseconds / IntPow(10, 3 - nPrecision);
						*pOut++ = '.';
						nLen = IntStr(pOut, i, NF_ZFILL, nPrecision, 0);
						pOut += nLen;
					}
				}
				break;
			case 'E':
				nFlags |= NF_UCASE;
				ch = 'e';
			case 'e':
			case 'f':
				nFlags &= ~NF_ZFILL;
				if (ch == 'e') nFlags |= NF_FLOATING;
				if (nWidth < 0) nWidth = 0;
				if (nPrecision < 0) nPrecision = 6;					// default precision: 6
				Value.d = va_arg(ArgPtr, double);
				nLen = FltStr(pOut, Value.d, nFlags, nPrecision, nWidth);
				pOut += nLen;
				break;
			case 'a':								// IP Address
				nWidth = (nWidth < 0) ? 0 : 3;
				Value.u32 = va_arg(ArgPtr, UINT32);
				for (i = 0; i < 4; i++) {
					nLen = IntStr(pOut, Value.aU8[i], NF_DEC, 0, nWidth);
					pOut += nLen;
					if (i < 3) *pOut++ = '.';
				}
				break;
			case 'm':								// memory
				if (nWidth <= 0) nWidth = 1;
				Value.p.pVoid = va_arg(ArgPtr, LPVOID);
				for (i = 1; i <= nWidth; i++) {
					switch (nPrecision) {
					case 2:
						nLen = IntStr(pOut, *Value.p.pU16++, NF_HEX | NF_UNSIGNED | NF_ZFILL, 4, 0);
						break;
					case 4:
						nLen = IntStr(pOut, *Value.p.pU32++, NF_HEX | NF_UNSIGNED | NF_ZFILL, 8, 0);
						break;
					case 8:
						nLen = IntStr(pOut, *Value.p.pU64++, NF_HEX | NF_UNSIGNED | NF_ZFILL, 16, 0);
						break;
					default:
						nLen = IntStr(pOut, *Value.p.pU8++, NF_HEX | NF_UNSIGNED | NF_ZFILL, 2, 0);
					}
					pOut += nLen;
					if (i < nWidth) *pOut++ = ' ';
				}
				break;
			case 'X':
				nFlags |= NF_UCASE;
			case 'x':
				nFlags |= NF_HEX | NF_UNSIGNED;
			case 'o':
			case 'b':
			case 'u':
			case 'd':
			case 'i':								// signed decimal output
				if (nWidth < 0) nWidth = 0;
				if (nPrecision <= 0) nPrecision = 0;
				if (nPrecision || !nWidth) nFlags &= ~NF_ZFILL;
				switch (ch) {
				case 'u':
					nFlags |= NF_UNSIGNED;
				case 'd':
				case 'i':								// signed decimal output
					if (nPrecision) nFlags |= NF_SINGLE;
					break;
				case 'o':
					nFlags |= NF_OCT | NF_UNSIGNED;
					break;
				case 'b':
					nFlags |= NF_BIN | NF_UNSIGNED;
					break;
				}
				if (nFlags & NF_ZFILL) {
					nPrecision = nWidth;
					nWidth = 0;
				}
				if (bInt64) Value.i64 = va_arg(ArgPtr, INT64);
				else {
					Value.i64 = va_arg(ArgPtr, INT32);
					if (nFlags & NF_UNSIGNED) Value.u32hi = 0;
				}
				nLen = IntStr(pOut, Value.i64, nFlags, nPrecision, nWidth);
				pOut += nLen;
			}
			nState = ST_NORMAL;
		} // switch (nState)
		if (bRead) ch = *lpFormat++;
	} // while
	*pOut = '\0';
    return pOut - lpBuf;
}
//*********************************************************************
INT32 __cdecl StrPrint(LPSTR lpBuf, LPSTR lpFormat, ...) {
INT32		nRet;
va_list		ArgPtr;

	va_start(ArgPtr, lpFormat);
	nRet = _StrPrint(lpBuf, lpFormat, ArgPtr);
	va_end(ArgPtr);
    return nRet;
}
