/********************************************************************
 * Copyright (c) 2011-21 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skCLib32 - strtoip.c												*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
// **********************************************************************************
UINT32 __stdcall StrToIP(LPSTR lpStr, UINT32 nDef) {
char		c, cBuf[256];
LPSTR		pStr;
UINT32		nRet, nVal;
INT32		i, nLen,nScan;
BOOL		bOK;

	nLen = TrimCpyN(cBuf, lpStr, sizeof(cBuf), TSM_BOTH);
	bOK = TRUE;
	nRet = 0;
	pStr = cBuf;
	for (i = 0; (i < 4) && bOK && nLen; i++) {
		c = i < 3 ? '.' : 0;
		nVal = (INT32) IntVal(pStr, NF_UDEC, 0, &nScan);
		if ((nScan > 0) && (pStr[nScan] == c) && (nVal <= 255)) {
			nRet |= nVal << (i * 8);
			if (c) nScan++;
			nLen -= nScan;
			pStr += nScan;
		}
		else {
			bOK = FALSE;
		}
	}
	if (nLen || !bOK) nRet = nDef;
	return nRet;
}