/********************************************************************
 * Copyright (c) 2011-16 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - syslog_message.c										*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

#define SYSLOG_PORT		514
#define MAX_MONTH		12
static LPSTR	m_MonthNames[MAX_MONTH]		= {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};
// **********************************************************************************
INT32 SysLog_Message(INT32 nFacility, UINT32 nPriority, LPSTR lpTag, INT32 nTagID, LPSTR lpContent) {
SKDPPACKET	pkt;
SYSTEMTIME	st;
INT32		nRet;

	if (!g_SKDPInfo.nSysLog) return -1;
	GetLocalTime(&st);
	LockThread(_SKDP_LOCK);
	MemClr(&pkt, sizeof(pkt));
	pkt.Adr.nFamily = AF_INET;
	pkt.Adr.nPort = ByteSwap16(SYSLOG_PORT);
	pkt.Adr.nIp = g_SKDPInfo.nSysLog;
	pkt.nLen = StrPrint(pkt.cUdp, "<%d>%s%3d %T %s %s%[[%d]%]: %s", (nFacility << 3) + nPriority, m_MonthNames[st.wMonth - 1], st.wDay, &st,
						g_SKDPInfo.UsrInf.cPCName, lpTag, nTagID, nTagID, lpContent);
	nRet = SKDP_SendPacket(NULL, &pkt, FALSE);
	UnLockThread(_SKDP_LOCK);
	return nRet;
}
