/********************************************************************
 * Copyright (c) 2011-21 by SK karoly.saly@matrasoft.hu				*
 *																	*
 * skclib32 - tcpconnect.c											*
 ********************************************************************/
#define WIN32_LEAN_AND_MEAN
#include <skclib32.h>
#include "udpprivate.h"

#pragma comment(lib, "ws2_32.lib")
// **********************************************************************************
INT32 __stdcall TcpConnect(INT32 nSocket, INT32 nIp, INT32 nPort, INT32 nTimeOut, LPINT32 lpErr) {
SOCKETADDRESS	sktAddr;
fd_set			fdSet;
TIMEVAL			tm;
UINT32			ul;
INT32			nRes, nLen;
BOOL			bOK, bTOut;

	MemClr(&sktAddr, sizeof(sktAddr));
	sktAddr.nFamily = AF_INET;
	sktAddr.nPort = ByteSwap16(nPort);
	sktAddr.nIp = nIp;
	bTOut = FALSE;
	ul = 1;
	ioctlsocket(nSocket, FIONBIO, &ul);		//set as non-blocking
	nRes = connect(nSocket, &sktAddr.sa, sizeof(sktAddr));
	if (nRes == SOCKET_ERROR) {
		tm.tv_sec = nTimeOut / 1000;
		tm.tv_usec = (nTimeOut % 1000) * 1000;
		FD_ZERO(&fdSet);
		FD_SET(nSocket, &fdSet);
		nLen = sizeof(INT32);
		nRes = select(nSocket + 1, NULL, &fdSet, NULL, &tm);
		if (nRes > 0) {
			getsockopt(nSocket, SOL_SOCKET, SO_ERROR, (LPSTR) &nRes, &nLen);
			bOK = nRes == 0 ? TRUE : FALSE;
		}
		else {
			bOK = FALSE;
			if (nRes == 0) {
				bTOut = TRUE;
			}
			else {
				nRes = WSAGetLastError();
			}
		}
	}
	else {
		nRes = 0;
		bOK = TRUE;
	}
	ul = 0;
	ioctlsocket(nSocket, FIONBIO, &ul);		//set as blocking
	if (lpErr) *lpErr = nRes;
	nRes = bOK ? 0 : (bTOut ? -1 : 1);
	return nRes;
};
